/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.codeVision.BypassBasedPlaceholderCollector;
import com.intellij.codeInsight.codeVision.CodeVisionAnchorKind;
import com.intellij.codeInsight.codeVision.CodeVisionPlaceholderCollector;
import com.intellij.codeInsight.codeVision.CodeVisionProvider;
import com.intellij.codeInsight.codeVision.CodeVisionRelativeOrdering;
import com.intellij.codeInsight.codeVision.CodeVisionState;
import com.intellij.codeInsight.codeVision.ui.model.ClickableTextCodeVisionEntry;
import com.intellij.codeInsight.hints.AnnotationResult;
import com.intellij.codeInsight.hints.CodeAuthorClickHandler;
import com.intellij.codeInsight.hints.InlayHintsUtils;
import com.intellij.codeInsight.hints.VcsCodeAuthorInfo;
import com.intellij.codeInsight.hints.VcsCodeVisionLanguageContext;
import com.intellij.codeInsight.hints.VcsCodeVisionProviderKt;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.vcs.CacheableAnnotationProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u001cH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lcom/intellij/codeInsight/hints/VcsCodeVisionProvider;", "Lcom/intellij/codeInsight/codeVision/CodeVisionProvider;", "", "()V", "defaultAnchor", "Lcom/intellij/codeInsight/codeVision/CodeVisionAnchorKind;", "getDefaultAnchor", "()Lcom/intellij/codeInsight/codeVision/CodeVisionAnchorKind;", "id", "", "getId", "()Ljava/lang/String;", "name", "getName", "relativeOrderings", "", "Lcom/intellij/codeInsight/codeVision/CodeVisionRelativeOrdering;", "getRelativeOrderings", "()Ljava/util/List;", "computeCodeVision", "Lcom/intellij/codeInsight/codeVision/CodeVisionState;", "editor", "Lcom/intellij/openapi/editor/Editor;", "uiData", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/Unit;)Lcom/intellij/codeInsight/codeVision/CodeVisionState;", "getPlaceholderCollector", "Lcom/intellij/codeInsight/codeVision/CodeVisionPlaceholderCollector;", "psiFile", "Lcom/intellij/psi/PsiFile;", "hasSupportedVcs", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "isAvailableFor", "precomputeOnUiThread", "preparePreview", "Companion", "intellij.platform.vcs.impl"})
public final class VcsCodeVisionProvider
implements CodeVisionProvider<Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String id = "vcs.code.vision";

    public boolean isAvailableFor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return VcsCodeVisionLanguageContext.Companion.getProvidersExtensionPoint().hasAnyExtensions();
    }

    public void precomputeOnUiThread(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
    }

    public void preparePreview(@NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VcsCodeVisionProviderKt.access$addPreviewInfo(editor);
    }

    @NotNull
    public CodeVisionState computeCodeVision(@NotNull Editor editor, @NotNull Unit uiData) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)uiData, (String)"uiData");
        return (CodeVisionState)ActionsKt.runReadAction((Function0)((Function0)new Function0<CodeVisionState>(editor, this){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ VcsCodeVisionProvider this$0;
            {
                this.$editor = $editor;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CodeVisionState invoke() {
                List additionalContexts;
                Project project2 = this.$editor.getProject();
                if (project2 == null) {
                    return (CodeVisionState)CodeVisionState.Companion.getREADY_EMPTY();
                }
                Project project3 = project2;
                Document document2 = this.$editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
                Document document3 = document2;
                PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project3).getPsiFile(document3);
                if (psiFile2 == null) {
                    return (CodeVisionState)CodeVisionState.Companion.getREADY_EMPTY();
                }
                PsiFile file = psiFile2;
                if (!VcsCodeVisionProvider.access$hasSupportedVcs(this.this$0, project3, file, this.$editor)) {
                    return (CodeVisionState)CodeVisionState.Companion.getREADY_EMPTY();
                }
                VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                VirtualFile virtualFile2 = virtualFile;
                if (ProjectFileIndex.getInstance((Project)project3).isInLibrarySource(virtualFile2)) {
                    return (CodeVisionState)CodeVisionState.Companion.getREADY_EMPTY();
                }
                Language language = file.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                Language fileLanguage = language;
                VcsCodeVisionLanguageContext fileContext = (VcsCodeVisionLanguageContext)VcsCodeVisionLanguageContext.Companion.getProvidersExtensionPoint().forLanguage(fileLanguage);
                if (fileContext == null) {
                    Object object = VcsCodeVisionLanguageContext.Companion.getProvidersExtensionPoint().getPoint();
                    if (object != null && (object = object.getExtensionList()) != null) {
                        void $this$filterTo$iv$iv;
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = (Iterable)object;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            KeyedLazyInstance keyedLazyInstance = (KeyedLazyInstance)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add((VcsCodeVisionLanguageContext)it.getInstance());
                        }
                        Iterable $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$filter = false;
                        destination$iv$iv = $this$filter$iv;
                        Collection destination$iv$iv2 = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (E element$iv$iv : $this$filterTo$iv$iv) {
                            VcsCodeVisionLanguageContext it = (VcsCodeVisionLanguageContext)element$iv$iv;
                            boolean bl = false;
                            if (!it.isCustomFileAccepted(file)) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        v6 = (List)destination$iv$iv2;
                    } else {
                        v6 = CollectionsKt.emptyList();
                    }
                } else {
                    v6 = additionalContexts = CollectionsKt.emptyList();
                }
                if (fileContext == null && additionalContexts.isEmpty()) {
                    return (CodeVisionState)CodeVisionState.Companion.getREADY_EMPTY();
                }
                AnnotationResult aspectResult = VcsCodeVisionProviderKt.access$getAspect(file, this.$editor);
                if (Intrinsics.areEqual((Object)aspectResult, (Object)AnnotationResult.NoAnnotation.INSTANCE)) {
                    return (CodeVisionState)new CodeVisionState.Ready(CollectionsKt.emptyList());
                }
                if (Intrinsics.areEqual((Object)aspectResult, (Object)AnnotationResult.NotReady.INSTANCE)) {
                    return (CodeVisionState)CodeVisionState.NotReady.INSTANCE;
                }
                if (!(aspectResult instanceof AnnotationResult.Success)) {
                    throw new NoWhenBranchMatchedException();
                }
                LineAnnotationAspect aspect = (LineAnnotationAspect)((AnnotationResult.Success)aspectResult).getRes();
                ArrayList<Pair> lenses = new ArrayList<Pair>();
                SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file));
                Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"psiTraverser(...)");
                SyntaxTraverser traverser = syntaxTraverser;
                for (PsiElement element : traverser.preOrderDfsTraversal()) {
                    VcsCodeVisionLanguageContext elementContext = null;
                    Language language2 = null;
                    if (fileContext != null) {
                        elementContext = fileContext;
                        language2 = fileLanguage;
                    } else {
                        Language language3 = element.getLanguage();
                        Intrinsics.checkNotNullExpressionValue((Object)language3, (String)"getLanguage(...)");
                        language2 = language3;
                        elementContext = (VcsCodeVisionLanguageContext)VcsCodeVisionLanguageContext.Companion.getProvidersExtensionPoint().forLanguage(language2);
                        if (!additionalContexts.contains(elementContext)) continue;
                    }
                    if (elementContext == null) continue;
                    Intrinsics.checkNotNull((Object)element);
                    if (!elementContext.isAccepted(element)) continue;
                    TextRange textRange = InlayHintsUtils.INSTANCE.getTextRangeWithoutLeadingCommentsAndWhitespaces(element);
                    int length = this.$editor.getDocument().getTextLength();
                    TextRange adjustedRange = new TextRange(Integer.min(textRange.getStartOffset(), length), Integer.min(textRange.getEndOffset(), length));
                    TextRange trimmedRange = elementContext.computeEffectiveRange(element);
                    TextRange adjustedTrimmedRange = new TextRange(Integer.min(trimmedRange.getStartOffset(), length), Integer.min(trimmedRange.getEndOffset(), length));
                    VcsCodeAuthorInfo vcsCodeAuthorInfo = (VcsCodeAuthorInfo)VcsCodeVisionProviderKt.access$getPREVIEW_INFO_KEY$p().get((UserDataHolder)this.$editor);
                    if (vcsCodeAuthorInfo == null) {
                        Project project4 = element.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
                        vcsCodeAuthorInfo = VcsCodeVisionProviderKt.access$getCodeAuthorInfo(project4, adjustedTrimmedRange, this.$editor, aspect);
                    }
                    VcsCodeAuthorInfo codeAuthorInfo = vcsCodeAuthorInfo;
                    String text2 = VcsCodeVisionProviderKt.access$getText(codeAuthorInfo);
                    Icon icon2 = codeAuthorInfo.getMainAuthor() != null ? AllIcons.Vcs.Author : null;
                    CodeAuthorClickHandler clickHandler = new CodeAuthorClickHandler(element, language2);
                    ClickableTextCodeVisionEntry entry2 = new ClickableTextCodeVisionEntry(text2, this.this$0.getId(), (Function2)clickHandler, icon2, text2, text2, CollectionsKt.emptyList());
                    entry2.setShowInMorePopup(false);
                    lenses.add(TuplesKt.to((Object)adjustedRange, (Object)entry2));
                }
                return (CodeVisionState)new CodeVisionState.Ready((List)lenses);
            }
        }));
    }

    private final boolean hasSupportedVcs(Project project2, PsiFile file, Editor editor) {
        if (VcsCodeVisionProviderKt.access$hasPreviewInfo(editor)) {
            return true;
        }
        AbstractVcs abstractVcs = ProjectLevelVcsManager.getInstance(project2).getVcsFor(file.getVirtualFile());
        if (abstractVcs == null) {
            return false;
        }
        AbstractVcs vcs = abstractVcs;
        return Intrinsics.areEqual((Object)"Git", (Object)vcs.getName());
    }

    @Nullable
    public CodeVisionPlaceholderCollector getPlaceholderCollector(@NotNull Editor editor, @Nullable PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (psiFile2 == null) {
            return null;
        }
        Language language = psiFile2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        Project project2 = editor.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        VcsCodeVisionLanguageContext vcsCodeVisionLanguageContext = (VcsCodeVisionLanguageContext)VcsCodeVisionLanguageContext.Companion.getProvidersExtensionPoint().forLanguage(language2);
        if (vcsCodeVisionLanguageContext == null) {
            return null;
        }
        VcsCodeVisionLanguageContext visionLanguageContext = vcsCodeVisionLanguageContext;
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        AbstractVcs abstractVcs = ProjectLevelVcsManager.getInstance(project3).getVcsFor(virtualFile);
        if (abstractVcs == null) {
            return null;
        }
        AbstractVcs vcs = abstractVcs;
        if (!Intrinsics.areEqual((Object)"Git", (Object)vcs.getName())) {
            return null;
        }
        if (!(vcs.getAnnotationProvider() instanceof CacheableAnnotationProvider)) {
            return null;
        }
        return (CodeVisionPlaceholderCollector)new BypassBasedPlaceholderCollector(visionLanguageContext){
            final /* synthetic */ VcsCodeVisionLanguageContext $visionLanguageContext;
            {
                this.$visionLanguageContext = $visionLanguageContext;
            }

            @NotNull
            public List<TextRange> collectPlaceholders(@NotNull PsiElement element, @NotNull Editor editor) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                ArrayList<TextRange> ranges = new ArrayList<TextRange>();
                if (this.$visionLanguageContext.isAccepted(element)) {
                    ranges.add(InlayHintsUtils.INSTANCE.getTextRangeWithoutLeadingCommentsAndWhitespaces(element));
                }
                return ranges;
            }
        };
    }

    @NotNull
    public String getName() {
        String string2 = VcsBundle.message("label.code.author.inlay.hints", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @NotNull
    public List<CodeVisionRelativeOrdering> getRelativeOrderings() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public CodeVisionAnchorKind getDefaultAnchor() {
        return CodeVisionAnchorKind.Default;
    }

    @NotNull
    public String getId() {
        return id;
    }

    public static final /* synthetic */ boolean access$hasSupportedVcs(VcsCodeVisionProvider $this, Project project2, PsiFile file, Editor editor) {
        return $this.hasSupportedVcs(project2, file, editor);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/codeInsight/hints/VcsCodeVisionProvider$Companion;", "", "()V", "id", "", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

