/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.api.impls;

import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Function;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlParameterInfoHandler
implements ParameterInfoHandler<XmlTag, XmlElementDescriptor> {
    private static final Comparator<XmlAttributeDescriptor> COMPARATOR = Comparator.comparing(PsiMetaData::getName);

    public static XmlAttributeDescriptor[] getSortedDescriptors(XmlElementDescriptor p) {
        XmlAttributeDescriptor[] xmlAttributeDescriptors = p.getAttributesDescriptors(null);
        Arrays.sort(xmlAttributeDescriptors, COMPARATOR);
        return xmlAttributeDescriptors;
    }

    public XmlTag findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        XmlTag tag;
        XmlElementDescriptor descriptor;
        if (context == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(0);
        }
        XmlElementDescriptor xmlElementDescriptor = descriptor = (tag = XmlParameterInfoHandler.findXmlTag(context.getFile(), context.getOffset())) != null ? tag.getDescriptor() : null;
        if (descriptor == null) {
            return null;
        }
        context.setItemsToShow(new Object[]{descriptor});
        return tag;
    }

    public void showParameterInfo(@NotNull XmlTag element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(2);
        }
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset() + 1, (ParameterInfoHandler)this);
    }

    public XmlTag findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        PsiElement currentXmlTag;
        XmlTag tag;
        if (context == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(3);
        }
        if ((tag = XmlParameterInfoHandler.findXmlTag(context.getFile(), context.getOffset())) != null && ((currentXmlTag = context.getParameterOwner()) == null || currentXmlTag == tag)) {
            return tag;
        }
        return null;
    }

    public void updateParameterInfo(@NotNull XmlTag parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(5);
        }
        context.setParameterOwner((PsiElement)parameterOwner);
    }

    @Nullable
    private static XmlTag findXmlTag(PsiFile file, int offset) {
        if (!(file instanceof XmlFile)) {
            return null;
        }
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (!(element instanceof XmlTag)) continue;
            XmlTag tag = (XmlTag)element;
            PsiElement[] children = tag.getChildren();
            if (offset <= children[0].getTextRange().getStartOffset()) {
                return null;
            }
            for (PsiElement child : children) {
                XmlToken token;
                TextRange range = child.getTextRange();
                if (range.getStartOffset() <= offset && range.getEndOffset() > offset) {
                    return tag;
                }
                if (!(child instanceof XmlToken) || (token = (XmlToken)child).getTokenType() != XmlTokenType.XML_TAG_END) continue;
                return null;
            }
            return null;
        }
        return null;
    }

    public void updateUI(XmlElementDescriptor o, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(6);
        }
        XmlTag parameterOwner = (XmlTag)context.getParameterOwner();
        XmlParameterInfoHandler.updateElementDescriptor(o, context, (Function<? super String, Boolean>)((Function)s -> parameterOwner != null && parameterOwner.getAttributeValue((String)s) != null));
    }

    public static void updateElementDescriptor(XmlElementDescriptor descriptor, ParameterInfoUIContext context, Function<? super String, Boolean> attributePresentFun) {
        XmlAttributeDescriptor[] attributes = descriptor != null ? XmlParameterInfoHandler.getSortedDescriptors(descriptor) : XmlAttributeDescriptor.EMPTY;
        StringBuilder buffer = new StringBuilder();
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (attributes.length == 0) {
            buffer.append(XmlBundle.message("xml.tag.info.no.attributes", new Object[0]));
        } else {
            StringBuilder text1 = new StringBuilder(" ");
            StringBuilder text2 = new StringBuilder(" ");
            StringBuilder text3 = new StringBuilder(" ");
            for (XmlAttributeDescriptor attribute : attributes) {
                if (Boolean.TRUE.equals(attributePresentFun.fun((Object)attribute.getName()))) {
                    if (!text1.toString().equals(" ")) {
                        text1.append(", ");
                    }
                    text1.append(attribute.getName());
                    continue;
                }
                if (attribute.isRequired()) {
                    if (!text2.toString().equals(" ")) {
                        text2.append(", ");
                    }
                    text2.append(attribute.getName());
                    continue;
                }
                if (!text3.toString().equals(" ")) {
                    text3.append(", ");
                }
                text3.append(attribute.getName());
            }
            if (!text1.toString().equals(" ") && !text2.toString().equals(" ")) {
                text1.append(", ");
            }
            if (!text2.toString().equals(" ") && !text3.toString().equals(" ")) {
                text2.append(", ");
            }
            if (!text1.toString().equals(" ") && !text3.toString().equals(" ") && text2.toString().equals(" ")) {
                text1.append(", ");
            }
            buffer.append((CharSequence)text1);
            highlightStartOffset = buffer.length();
            buffer.append((CharSequence)text2);
            highlightEndOffset = buffer.length();
            buffer.append((CharSequence)text3);
        }
        context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, false, false, true, context.getDefaultParameterColor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterOwner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/api/impls/XmlParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUI";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

