/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CDataToTextIntention
implements IntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string2 = this.getFamilyName();
        if (string2 == null) {
            CDataToTextIntention.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string2 = XmlBundle.message("convert.cdata.to.text", new Object[0]);
        if (string2 == null) {
            CDataToTextIntention.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            CDataToTextIntention.$$$reportNull$$$0(2);
        }
        return CDataToTextIntention.getCData(editor, file) != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        ASTNode curr;
        PsiElement cdata;
        if (project2 == null) {
            CDataToTextIntention.$$$reportNull$$$0(3);
        }
        if ((cdata = CDataToTextIntention.getCData(editor, file)) == null) {
            return;
        }
        ASTNode node = cdata.getNode();
        ArrayList<ASTNode> cdatas = new ArrayList<ASTNode>();
        for (curr = node.getTreePrev(); curr != null && curr.getElementType() == XmlElementType.XML_CDATA; curr = curr.getTreePrev()) {
            cdatas.add(0, curr);
        }
        cdatas.add(node);
        for (curr = node.getTreeNext(); curr != null && curr.getElementType() == XmlElementType.XML_CDATA; curr = curr.getTreeNext()) {
            cdatas.add(curr);
        }
        StringBuilder text2 = new StringBuilder();
        for (ASTNode astNode : cdatas) {
            ASTNode textNode = astNode.getFirstChildNode().getTreeNext();
            if (textNode == null || textNode.getElementType() == XmlTokenType.XML_CDATA_END) continue;
            text2.append(StringUtil.escapeXmlEntities((String)textNode.getText()));
        }
        editor.getDocument().replaceString(((ASTNode)cdatas.get(0)).getStartOffset(), ((ASTNode)cdatas.get(cdatas.size() - 1)).getTextRange().getEndOffset(), (CharSequence)text2.toString());
    }

    private static PsiElement getCData(Editor editor, PsiFile file) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        PsiElement psiElement = parent = element != null ? element.getParent() : null;
        if (parent != null && parent.getNode() != null && parent.getNode().getElementType() == XmlElementType.XML_CDATA) {
            return parent;
        }
        element = file.findElementAt(offset - 1);
        PsiElement psiElement2 = parent = element != null ? element.getParent() : null;
        if (parent != null && parent.getNode() != null && parent.getNode().getElementType() == XmlElementType.XML_CDATA) {
            return parent;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/CDataToTextIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/CDataToTextIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3 -> new IllegalArgumentException(string2);
        };
    }
}

