'''OpenGL extension IMG.multisampled_render_to_texture

This module customises the behaviour of the 
OpenGL.raw.GLES1.IMG.multisampled_render_to_texture to provide a more 
Python-friendly API

Overview (from the spec)
	
	    This extension introduces functionality to perform multisampled 
		rendering to a color renderable texture, without requiring an 
		explicit resolve of multisample data. 
	
		Some GPU architectures - such as tile-based renderers - are
		capable of performing multisampled rendering by storing 
		multisample data in internal high-speed memory and downsampling the
		data when writing out to external memory after rendering has 
		finished. Since per-sample data is never written out to external 
		memory, this approach saves bandwidth and storage space. In this 
		case multisample data gets discarded, however this is acceptable
		in most cases.
	
		The extension provides a new command, FramebufferTexture2DMultisampleIMG, 
		which attaches a texture level to a framebuffer and enables 
		multisampled rendering to that texture level. 
	
		When the texture level is used as a source or destination for any 
		operation other than drawing to it, an implicit resolve of 
		multisampled color data is performed. After such a resolve, the 
		multisampled color data is discarded.
	
		In order to allow the use of multisampled depth and stencil buffers 
		when performing	multisampled rendering to a texture, the extension 
		also adds the command RenderbufferStorageMultisampleIMG.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/IMG/multisampled_render_to_texture.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES1 import _types, _glgets
from OpenGL.raw.GLES1.IMG.multisampled_render_to_texture import *
from OpenGL.raw.GLES1.IMG.multisampled_render_to_texture import _EXTENSION_NAME

def glInitMultisampledRenderToTextureIMG():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION