"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerPplRoute = registerPplRoute;
var _configSchema = require("@osd/config-schema");
var _shared = require("../../common/constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerPplRoute({
  router,
  facet
}) {
  router.post({
    path: `${_shared.PPL_BASE}${_shared.PPL_SEARCH}`,
    validate: {
      body: _configSchema.schema.object({
        query: _configSchema.schema.string(),
        format: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, req, res) => {
    const queryRes = await facet.describeQuery(context, req);
    if (queryRes.success) {
      const result = {
        body: {
          ...queryRes.data
        }
      };
      return res.ok(result);
    }
    return res.custom({
      statusCode: queryRes.data.statusCode || queryRes.data.status || 500,
      body: queryRes.data.body || queryRes.data.message || ''
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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