/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.lib;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.library.unit.Units;
import org.openhab.core.types.Type;

public class NumberExtensions {
    public static final BigDecimal NULL_DEFINITION = new BigDecimal(0);

    public static BigDecimal operator_plus(Number x, Number y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        if (xValue == null) {
            return yValue;
        }
        if (yValue == null) {
            return xValue;
        }
        return xValue.add(yValue);
    }

    public static BigDecimal operator_minus(Number x) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        if (xValue == null) {
            return xValue;
        }
        return xValue.negate();
    }

    public static BigDecimal operator_minus(Number x, Number y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        if (xValue == null) {
            return NumberExtensions.operator_minus(yValue);
        }
        if (yValue == null) {
            return xValue;
        }
        return xValue.subtract(yValue);
    }

    public static BigDecimal operator_multiply(Number x, Number y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        if (xValue == null) {
            return NULL_DEFINITION;
        }
        if (yValue == null) {
            return NULL_DEFINITION;
        }
        return xValue.multiply(yValue);
    }

    public static BigDecimal operator_divide(Number x, Number y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        return xValue.divide(yValue, 8, RoundingMode.HALF_UP);
    }

    public static boolean operator_equals(Number left, Number right) {
        if (NumberExtensions.oneIsQuantity(left, right)) {
            return false;
        }
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return rightValue == null;
        }
        if (rightValue == null) {
            return false;
        }
        return leftValue.compareTo(rightValue) == 0;
    }

    public static boolean operator_notEquals(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return rightValue != null;
        }
        if (rightValue == null) {
            return true;
        }
        return leftValue.compareTo(rightValue) != 0;
    }

    public static boolean operator_lessThan(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return true;
        }
        if (rightValue == null) {
            return false;
        }
        return leftValue.compareTo(rightValue) < 0;
    }

    public static boolean operator_greaterThan(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return false;
        }
        if (rightValue == null) {
            return true;
        }
        return leftValue.compareTo(rightValue) > 0;
    }

    public static boolean operator_lessEqualsThan(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return true;
        }
        if (rightValue == null) {
            return false;
        }
        return leftValue.compareTo(rightValue) <= 0;
    }

    public static boolean operator_greaterEqualsThan(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return rightValue == null;
        }
        if (rightValue == null) {
            return true;
        }
        return leftValue.compareTo(rightValue) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean operator_equals(Type type, Number x) {
        Type type2;
        Type type3 = type;
        if (type3 instanceof QuantityType) {
            QuantityType quantityType = (QuantityType)type3;
            QuantityType cfr_ignored_0 = (QuantityType)type3;
            Number number = x;
            if (number instanceof QuantityType) {
                void qx;
                void qtype;
                QuantityType quantityType2 = (QuantityType)number;
                QuantityType cfr_ignored_1 = (QuantityType)number;
                return NumberExtensions.operator_equals(qtype, qx);
            }
        }
        if ((type2 = type) instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type2;
            DecimalType cfr_ignored_2 = (DecimalType)type2;
            if (x != null) {
                void decimalType2;
                return decimalType2.toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) == 0;
            }
        }
        return type == x;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean operator_notEquals(Type type, Number x) {
        Type type2;
        Type type3 = type;
        if (type3 instanceof QuantityType) {
            QuantityType quantityType = (QuantityType)type3;
            QuantityType cfr_ignored_0 = (QuantityType)type3;
            Number number = x;
            if (number instanceof QuantityType) {
                void qx;
                void qtype;
                QuantityType quantityType2 = (QuantityType)number;
                QuantityType cfr_ignored_1 = (QuantityType)number;
                return NumberExtensions.operator_notEquals(qtype, qx);
            }
        }
        if ((type2 = type) instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type2;
            DecimalType cfr_ignored_2 = (DecimalType)type2;
            if (x != null) {
                void decimalType2;
                return decimalType2.toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) != 0;
            }
        }
        return type != x;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean operator_greaterThan(Type type, Number x) {
        Type type2;
        Type type3 = type;
        if (type3 instanceof QuantityType) {
            QuantityType quantityType = (QuantityType)type3;
            QuantityType cfr_ignored_0 = (QuantityType)type3;
            Number number = x;
            if (number instanceof QuantityType) {
                void qx;
                void qtype;
                QuantityType quantityType2 = (QuantityType)number;
                QuantityType cfr_ignored_1 = (QuantityType)number;
                return NumberExtensions.operator_greaterThan(qtype, qx);
            }
        }
        if ((type2 = type) instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type2;
            DecimalType cfr_ignored_2 = (DecimalType)type2;
            if (x != null) {
                void decimalType2;
                return decimalType2.toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) > 0;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean operator_greaterEqualsThan(Type type, Number x) {
        Type type2;
        Type type3 = type;
        if (type3 instanceof QuantityType) {
            QuantityType quantityType = (QuantityType)type3;
            QuantityType cfr_ignored_0 = (QuantityType)type3;
            Number number = x;
            if (number instanceof QuantityType) {
                void qx;
                void qtype;
                QuantityType quantityType2 = (QuantityType)number;
                QuantityType cfr_ignored_1 = (QuantityType)number;
                return NumberExtensions.operator_greaterEqualsThan(qtype, qx);
            }
        }
        if ((type2 = type) instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type2;
            DecimalType cfr_ignored_2 = (DecimalType)type2;
            if (x != null) {
                void decimalType2;
                return decimalType2.toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) >= 0;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean operator_lessThan(Type type, Number x) {
        Type type2;
        Type type3 = type;
        if (type3 instanceof QuantityType) {
            QuantityType quantityType = (QuantityType)type3;
            QuantityType cfr_ignored_0 = (QuantityType)type3;
            Number number = x;
            if (number instanceof QuantityType) {
                void qx;
                void qtype;
                QuantityType quantityType2 = (QuantityType)number;
                QuantityType cfr_ignored_1 = (QuantityType)number;
                return NumberExtensions.operator_lessThan(qtype, qx);
            }
        }
        if ((type2 = type) instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type2;
            DecimalType cfr_ignored_2 = (DecimalType)type2;
            if (x != null) {
                void decimalType2;
                return decimalType2.toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) < 0;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean operator_lessEqualsThan(Type type, Number x) {
        Type type2;
        Type type3 = type;
        if (type3 instanceof QuantityType) {
            QuantityType quantityType = (QuantityType)type3;
            QuantityType cfr_ignored_0 = (QuantityType)type3;
            Number number = x;
            if (number instanceof QuantityType) {
                void qx;
                void qtype;
                QuantityType quantityType2 = (QuantityType)number;
                QuantityType cfr_ignored_1 = (QuantityType)number;
                return NumberExtensions.operator_lessEqualsThan(qtype, qx);
            }
        }
        if ((type2 = type) instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type2;
            DecimalType cfr_ignored_2 = (DecimalType)type2;
            if (x != null) {
                void decimalType2;
                return decimalType2.toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) <= 0;
            }
        }
        return false;
    }

    public static QuantityType<?> operator_plus(QuantityType<?> x, QuantityType<?> y) {
        return x == null ? y : (y == null ? x : x.add(y));
    }

    public static QuantityType<?> operator_minus(QuantityType<?> x) {
        return x == null ? null : x.negate();
    }

    public static QuantityType<?> operator_minus(QuantityType<?> x, QuantityType<?> y) {
        return x == null ? NumberExtensions.operator_minus(y) : (y == null ? x : x.subtract(y));
    }

    public static QuantityType<?> operator_multiply(Number x, QuantityType<?> y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        if (xValue == null) {
            return QuantityType.ZERO;
        }
        if (y == null) {
            return QuantityType.ZERO;
        }
        return y.multiply(xValue);
    }

    public static QuantityType<?> operator_multiply(QuantityType<?> x, Number y) {
        return NumberExtensions.operator_multiply(y, x);
    }

    public static QuantityType<?> operator_multiply(QuantityType<?> x, QuantityType<?> y) {
        return x == null || y == null ? QuantityType.ZERO : x.multiply(y);
    }

    public static QuantityType<?> operator_divide(QuantityType<?> x, Number y) {
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        return x.divide(yValue);
    }

    public static QuantityType<?> operator_divide(Number x, QuantityType<?> y) {
        QuantityType xQuantity = new QuantityType(x, Units.ONE);
        return NumberExtensions.operator_divide(xQuantity, y);
    }

    public static QuantityType<?> operator_divide(QuantityType<?> x, QuantityType<?> y) {
        return x.divide(y);
    }

    public static boolean operator_equals(QuantityType<?> left, QuantityType<?> right) {
        return left.equals(right);
    }

    public static boolean operator_equals(QuantityType<?> left, Number right) {
        return NumberExtensions.operator_equals(left, right);
    }

    public static boolean operator_notEquals(QuantityType<?> left, QuantityType<?> right) {
        return !NumberExtensions.operator_equals(left, right);
    }

    public static boolean operator_notEquals(QuantityType<?> left, Number right) {
        return NumberExtensions.operator_notEquals(left, right);
    }

    public static boolean operator_lessThan(QuantityType<?> x, QuantityType<?> y) {
        if (x != null && y != null) {
            return x.compareTo(y) < 0;
        }
        return false;
    }

    public static boolean operator_lessThan(QuantityType<?> x, Number y) {
        return NumberExtensions.operator_lessThan(x, y);
    }

    public static boolean operator_lessEqualsThan(QuantityType<?> x, QuantityType<?> y) {
        if (x != null && y != null) {
            return x.compareTo(y) <= 0;
        }
        return false;
    }

    public static boolean operator_lessEqualsThan(QuantityType<?> x, Number y) {
        return NumberExtensions.operator_lessEqualsThan(x, y);
    }

    public static boolean operator_greaterThan(QuantityType<?> x, QuantityType<?> y) {
        if (x != null && y != null) {
            return x.compareTo(y) > 0;
        }
        return false;
    }

    public static boolean operator_greaterThan(QuantityType<?> x, Number y) {
        return NumberExtensions.operator_greaterThan(x, y);
    }

    public static boolean operator_greaterEqualsThan(QuantityType<?> x, QuantityType<?> y) {
        if (x != null && y != null) {
            return x.compareTo(y) >= 0;
        }
        return false;
    }

    public static boolean operator_greaterEqualsThan(QuantityType<?> x, Number y) {
        return NumberExtensions.operator_greaterEqualsThan(x, y);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal numberToBigDecimal(Number number) {
        Number number2 = number;
        if (number2 instanceof QuantityType) {
            void quantity;
            QuantityType quantityType = (QuantityType)number2;
            QuantityType cfr_ignored_0 = (QuantityType)number2;
            QuantityType state = quantity.toInvertibleUnit(quantity.getUnit().getSystemUnit());
            if (state != null) {
                return state.toBigDecimal();
            }
            return null;
        }
        Number number3 = number;
        if (number3 instanceof DecimalType) {
            void dtype;
            DecimalType state = (DecimalType)number3;
            DecimalType cfr_ignored_1 = (DecimalType)number3;
            return dtype.toBigDecimal();
        }
        Number number4 = number;
        if (number4 instanceof BigDecimal) {
            void decimal;
            BigDecimal bigDecimal = (BigDecimal)number4;
            BigDecimal cfr_ignored_2 = (BigDecimal)number4;
            return decimal;
        }
        Number number5 = number;
        if (number5 instanceof Long) {
            void value;
            Long l = (Long)number5;
            Long cfr_ignored_3 = (Long)number5;
            return BigDecimal.valueOf(value.longValue());
        }
        Number number6 = number;
        if (number6 instanceof Integer) {
            void value;
            Integer n = (Integer)number6;
            Integer cfr_ignored_4 = (Integer)number6;
            return BigDecimal.valueOf(value.intValue());
        }
        if (number != null) {
            return new BigDecimal(number.toString());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean oneIsQuantity(Number left, Number right) {
        block3: {
            block4: {
                void rightQuantity;
                Number number;
                block2: {
                    void leftQuantity;
                    Number number2 = left;
                    if (!(number2 instanceof QuantityType)) break block2;
                    QuantityType quantityType = (QuantityType)number2;
                    QuantityType cfr_ignored_0 = (QuantityType)number2;
                    if (!NumberExtensions.isAbstractUnitOne(leftQuantity)) break block3;
                }
                if (!((number = right) instanceof QuantityType)) break block4;
                QuantityType quantityType = (QuantityType)number;
                QuantityType cfr_ignored_1 = (QuantityType)number;
                if (!NumberExtensions.isAbstractUnitOne(rightQuantity)) break block3;
            }
            return false;
        }
        return true;
    }

    private static boolean isAbstractUnitOne(QuantityType<?> left) {
        return Units.ONE.equals(left.getUnit());
    }
}

