/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parser.impl;

import de.focus_shift.jollyday.core.Holiday;
import de.focus_shift.jollyday.core.parser.HolidayParser;
import de.focus_shift.jollyday.core.parser.functions.CalculateEasterSunday;
import de.focus_shift.jollyday.core.parser.functions.CreateHoliday;
import de.focus_shift.jollyday.core.parser.functions.MoveDateRelative;
import de.focus_shift.jollyday.core.parser.predicates.ValidLimitation;
import de.focus_shift.jollyday.core.spi.Described;
import de.focus_shift.jollyday.core.spi.Holidays;
import de.focus_shift.jollyday.core.spi.Movable;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;

public class ChristianHolidayParser
implements HolidayParser {
    @Override
    public List<Holiday> parse(int year, Holidays holidays) {
        return holidays.christianHolidays().stream().filter(new ValidLimitation(year)).map(ch -> {
            LocalDate easterSunday = new CalculateEasterSunday(year).apply(ch.chronology());
            switch (ch.type()) {
                case EASTER: {
                    break;
                }
                case CLEAN_MONDAY: 
                case SHROVE_MONDAY: {
                    easterSunday = easterSunday.minusDays(48L);
                    break;
                }
                case MARDI_GRAS: 
                case CARNIVAL: {
                    easterSunday = easterSunday.minusDays(47L);
                    break;
                }
                case ASH_WEDNESDAY: {
                    easterSunday = easterSunday.minusDays(46L);
                    break;
                }
                case MAUNDY_THURSDAY: {
                    easterSunday = easterSunday.minusDays(3L);
                    break;
                }
                case GOOD_FRIDAY: {
                    easterSunday = easterSunday.minusDays(2L);
                    break;
                }
                case EASTER_SATURDAY: {
                    easterSunday = easterSunday.minusDays(1L);
                    break;
                }
                case EASTER_MONDAY: {
                    easterSunday = easterSunday.plusDays(1L);
                    break;
                }
                case EASTER_TUESDAY: {
                    easterSunday = easterSunday.plusDays(2L);
                    break;
                }
                case GENERAL_PRAYER_DAY: {
                    easterSunday = easterSunday.plusDays(26L);
                    break;
                }
                case ASCENSION_DAY: {
                    easterSunday = easterSunday.plusDays(39L);
                    break;
                }
                case PENTECOST: 
                case WHIT_SUNDAY: {
                    easterSunday = easterSunday.plusDays(49L);
                    break;
                }
                case WHIT_MONDAY: 
                case PENTECOST_MONDAY: {
                    easterSunday = easterSunday.plusDays(50L);
                    break;
                }
                case CORPUS_CHRISTI: {
                    easterSunday = easterSunday.plusDays(60L);
                    break;
                }
                case SACRED_HEART: {
                    easterSunday = easterSunday.plusDays(68L);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown christian holiday type " + ch.type());
                }
            }
            easterSunday = new MoveDateRelative(easterSunday).apply((Movable)ch);
            return new CreateHoliday(easterSunday).apply((Described)ch);
        }).collect(Collectors.toList());
    }
}

