/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.transform;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.OpenHAB;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.transform.TransformationException;
import org.openhab.core.transform.TransformationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractFileTransformationService<T>
implements TransformationService {
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private @Nullable WatchService watchService = null;
    protected final Map<String, T> cachedFiles = new ConcurrentHashMap<String, T>();
    private final Map<WatchKey, Path> registeredKeys = new ConcurrentHashMap<WatchKey, Path>();
    protected final List<String> watchedDirectories = new ArrayList<String>();
    private final Logger logger = LoggerFactory.getLogger(AbstractFileTransformationService.class);
    @NonNullByDefault(value={})
    private LocaleProvider localeProvider;
    @NonNullByDefault(value={})
    private ServiceTracker<LocaleProvider, LocaleProvider> localeProviderTracker;

    protected void activate(BundleContext context) {
        this.localeProviderTracker = new ServiceTracker(context, LocaleProvider.class, (ServiceTrackerCustomizer)new LocaleProviderServiceTrackerCustomizer(context));
        this.localeProviderTracker.open();
    }

    protected void deactivate() {
        this.localeProviderTracker.close();
        this.stopWatchService();
    }

    protected Locale getLocale() {
        return this.localeProvider.getLocale();
    }

    @Override
    public @Nullable String transform(String filename, String source) throws TransformationException {
        if (filename == null || source == null) {
            throw new TransformationException("the given parameters 'filename' and 'source' must not be null");
        }
        WatchService watchService = this.getWatchService();
        this.processFolderEvents(watchService);
        String transformFile = this.getLocalizedProposedFilename(filename, watchService);
        T transform = this.cachedFiles.get(transformFile);
        if (transform == null) {
            transform = this.internalLoadTransform(transformFile);
            this.cachedFiles.put(transformFile, transform);
        }
        try {
            return this.internalTransform(transform, source);
        }
        catch (TransformationException e) {
            this.logger.warn("Could not transform '{}' with the file '{}' : {}", new Object[]{source, filename, e.getMessage()});
            return "";
        }
    }

    protected abstract @Nullable String internalTransform(T var1, String var2) throws TransformationException;

    protected abstract T internalLoadTransform(String var1) throws TransformationException;

    private synchronized WatchService getWatchService() throws TransformationException {
        WatchService watchService = this.watchService;
        if (watchService != null) {
            return watchService;
        }
        try {
            watchService = this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            this.logger.error("Unable to start transformation directory monitoring");
            throw new TransformationException("Cannot get a new watch service.");
        }
        this.watchSubDirectory("", watchService);
        return watchService;
    }

    private void watchSubDirectory(String subDirectory, WatchService watchService) {
        if (!this.watchedDirectories.contains(subDirectory)) {
            String watchedDirectory = this.getSourcePath() + subDirectory;
            Path transformFilePath = Paths.get(watchedDirectory, new String[0]);
            try {
                WatchKey registrationKey = transformFilePath.register(watchService, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                this.logger.debug("Watching directory {}", (Object)transformFilePath);
                this.watchedDirectories.add(subDirectory);
                this.registeredKeys.put(registrationKey, transformFilePath);
            }
            catch (IOException e) {
                this.logger.warn("Unable to watch transformation directory : {}", (Object)watchedDirectory);
                this.cachedFiles.clear();
            }
        }
    }

    private void processFolderEvents(WatchService watchService) {
        WatchKey key = watchService.poll();
        if (key != null) {
            for (WatchEvent<?> e : key.pollEvents()) {
                if (e.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent<?> ev = e;
                Path path = (Path)ev.context();
                this.logger.debug("Refreshing transformation file '{}'", (Object)path);
                for (String fileEntry : this.cachedFiles.keySet()) {
                    if (!fileEntry.endsWith(path.toString())) continue;
                    this.cachedFiles.remove(fileEntry);
                }
            }
            key.reset();
        }
    }

    private synchronized void stopWatchService() {
        if (this.watchService != null) {
            for (WatchKey watchKey : this.registeredKeys.keySet()) {
                watchKey.cancel();
            }
            this.registeredKeys.clear();
            this.watchedDirectories.clear();
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                this.logger.warn("Cannot deactivate transformation directory watcher", (Throwable)e);
            }
            this.watchService = null;
            this.cachedFiles.clear();
        }
    }

    private String getFileExtension(String fileName) {
        int extensionPos = fileName.lastIndexOf(46);
        int lastSeparatorPos = Math.max(fileName.lastIndexOf(47), fileName.lastIndexOf(92));
        return lastSeparatorPos > extensionPos ? "" : fileName.substring(extensionPos + 1);
    }

    protected String getLocalizedProposedFilename(String filename, WatchService watchService) {
        String alternatePath;
        File file = new File(filename);
        if (file.getParent() != null) {
            this.watchSubDirectory(file.getParent(), watchService);
        }
        String sourcePath = this.getSourcePath();
        String extension = this.getFileExtension(filename);
        if (!filename.matches(".*_[a-z]{2}." + extension + "$") && new File(alternatePath = sourcePath + filename.substring(0, filename.length() - extension.length() - 1) + "_" + this.getLocale().getLanguage() + "." + extension).exists()) {
            return alternatePath;
        }
        return sourcePath + filename;
    }

    protected String getSourcePath() {
        return OpenHAB.getConfigFolder() + File.separator + "transform" + File.separator;
    }

    protected List<String> getFilenames(String[] validExtensions) {
        File path = new File(this.getSourcePath());
        return Arrays.stream(path.listFiles(new FileExtensionsFilter(validExtensions))).map(File::getName).toList();
    }

    protected static class FileExtensionsFilter
    implements FilenameFilter {
        private final String[] validExtensions;

        public FileExtensionsFilter(String[] validExtensions) {
            this.validExtensions = validExtensions;
        }

        @Override
        public boolean accept(@Nullable File dir, @Nullable String name) {
            if (name != null) {
                String[] stringArray = this.validExtensions;
                int n = this.validExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    if (name.toLowerCase().endsWith("." + extension)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    private class LocaleProviderServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<LocaleProvider, LocaleProvider> {
        private final BundleContext context;

        public LocaleProviderServiceTrackerCustomizer(BundleContext context) {
            this.context = context;
        }

        public LocaleProvider addingService(@Nullable ServiceReference<LocaleProvider> reference) {
            AbstractFileTransformationService.this.localeProvider = (LocaleProvider)this.context.getService(reference);
            return AbstractFileTransformationService.this.localeProvider;
        }

        public void modifiedService(@Nullable ServiceReference<LocaleProvider> reference, LocaleProvider service) {
        }

        public void removedService(@Nullable ServiceReference<LocaleProvider> reference, LocaleProvider service) {
            AbstractFileTransformationService.this.localeProvider = null;
        }
    }
}

