/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;
import org.hibernate.service.spi.SessionFactoryServiceInitiatorContext;
import org.hibernate.stat.internal.StatisticsImpl;
import org.hibernate.stat.spi.StatisticsFactory;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

public class StatisticsInitiator
implements SessionFactoryServiceInitiator<StatisticsImplementor> {
    private static final @UnknownKeyFor @NonNull @Initialized CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)StatisticsInitiator.class.getName());
    public static final @UnknownKeyFor @NonNull @Initialized StatisticsInitiator INSTANCE = new StatisticsInitiator();

    @Override
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized StatisticsImplementor> getServiceInitiated() {
        return StatisticsImplementor.class;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized StatisticsImplementor initiateService(@UnknownKeyFor @NonNull @Initialized SessionFactoryServiceInitiatorContext context) {
        Object configValue = NullnessUtil.castNonNull(context.getServiceRegistry().getService(ConfigurationService.class)).getSettings().get("hibernate.stats.factory");
        return this.initiateServiceInternal(context.getSessionFactory(), configValue, context.getServiceRegistry());
    }

    private @UnknownKeyFor @NonNull @Initialized StatisticsImplementor initiateServiceInternal(@UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor sessionFactory, @Nullable @UnknownKeyFor @Initialized Object configValue, @UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor registry) {
        StatisticsFactory statisticsFactory;
        if (configValue == null) {
            statisticsFactory = null;
        } else if (configValue instanceof StatisticsFactory) {
            statisticsFactory = (StatisticsFactory)configValue;
        } else {
            ClassLoaderService classLoaderService = NullnessUtil.castNonNull(registry.getService(ClassLoaderService.class));
            try {
                statisticsFactory = (StatisticsFactory)classLoaderService.classForName(configValue.toString()).newInstance();
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HibernateException("Unable to instantiate specified StatisticsFactory implementation [" + configValue + "]", e);
            }
        }
        StatisticsImplementor statistics = statisticsFactory == null ? new StatisticsImpl(sessionFactory) : statisticsFactory.buildStatistics(sessionFactory);
        boolean enabled = sessionFactory.getSessionFactoryOptions().isStatisticsEnabled();
        statistics.setStatisticsEnabled(enabled);
        LOG.debugf("Statistics initialized [enabled=%s]", enabled);
        return statistics;
    }
}

