/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public class UlimitCheck {
    private static final Logger logger = new LoggerImpl(UlimitCheck.class.getName());

    private static String getOutputFromCommand(String command) {
        ProcessBuilder pb = new ProcessBuilder("bash", "-c", command);
        pb.redirectErrorStream(true);
        try {
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String output = br.lines().reduce(String::concat).orElse("null?");
            br.close();
            return output;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static int parseInt(String s2) {
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException n) {
            return Integer.MAX_VALUE;
        }
    }

    public static void printUlimits() {
        boolean warn;
        String fileLimit = UlimitCheck.getOutputFromCommand("ulimit -n");
        String fileLimitHard = UlimitCheck.getOutputFromCommand("ulimit -Hn");
        String threadLimit = UlimitCheck.getOutputFromCommand("ulimit -u");
        String threadLimitHard = UlimitCheck.getOutputFromCommand("ulimit -Hu");
        StringBuilder sb = new StringBuilder("Running with open files limit ").append(fileLimit).append(" (hard ").append(fileLimitHard).append(')').append(", thread limit ").append(threadLimit).append(" (hard ").append(threadLimitHard).append(").");
        boolean bl = warn = UlimitCheck.parseInt(fileLimit) <= 4096 || UlimitCheck.parseInt(threadLimit) <= 2048;
        if (warn) {
            sb.append(" These values are too low and they will limit the ").append("number of participants that the bridge can serve ").append("simultaneously.");
            logger.warn(sb);
        } else {
            logger.info(sb);
        }
    }
}

