/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.videobridge.cc.allocation.AllocationSettings;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.cc.config.BitrateControllerConfig;
import org.jitsi.videobridge.message.ReceiverVideoConstraintsMessage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u0006\u0010\u001a\u001a\u00020\u0018J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jitsi/videobridge/cc/allocation/AllocationSettingsWrapper;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;)V", "logger", "selectedSources", "", "", "lastN", "", "getLastN$jitsi_videobridge", "()I", "setLastN$jitsi_videobridge", "(I)V", "videoConstraints", "", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "defaultConstraints", "assumedBandwidthBps", "", "onStageSources", "allocationSettings", "Lorg/jitsi/videobridge/cc/allocation/AllocationSettings;", "create", "get", "setBandwidthAllocationSettings", "", "message", "Lorg/jitsi/videobridge/message/ReceiverVideoConstraintsMessage;", "setLastN", "jitsi-videobridge"})
public final class AllocationSettingsWrapper {
    @NotNull
    private final Logger logger;
    @NotNull
    private List<String> selectedSources;
    private int lastN;
    @NotNull
    private Map<String, VideoConstraints> videoConstraints;
    @NotNull
    private VideoConstraints defaultConstraints;
    private long assumedBandwidthBps;
    @NotNull
    private List<String> onStageSources;
    @NotNull
    private AllocationSettings allocationSettings;

    public AllocationSettingsWrapper(@NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.selectedSources = CollectionsKt.emptyList();
        this.lastN = AllocationSettings.Companion.getDefaultInitialLastN();
        this.videoConstraints = MapsKt.emptyMap();
        this.defaultConstraints = new VideoConstraints(BitrateControllerConfig.config.thumbnailMaxHeightPx(), 0.0, 2, null);
        this.assumedBandwidthBps = -1L;
        this.onStageSources = CollectionsKt.emptyList();
        this.allocationSettings = this.create();
    }

    public /* synthetic */ AllocationSettingsWrapper(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            logger = new LoggerImpl(AllocationSettingsWrapper.class.getName());
        }
        this(logger);
    }

    public final int getLastN$jitsi_videobridge() {
        return this.lastN;
    }

    public final void setLastN$jitsi_videobridge(int n) {
        this.lastN = n;
    }

    private final AllocationSettings create() {
        List<String> list = this.onStageSources;
        List<String> list2 = this.selectedSources;
        Map<String, VideoConstraints> map = this.videoConstraints;
        VideoConstraints videoConstraints = this.defaultConstraints;
        int n = this.lastN;
        long l = this.assumedBandwidthBps;
        return new AllocationSettings(null, null, list, list2, map, n, videoConstraints, l, 3, null);
    }

    @NotNull
    public final AllocationSettings get() {
        return this.allocationSettings;
    }

    public final boolean setBandwidthAllocationSettings(@NotNull ReceiverVideoConstraintsMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        boolean changed = false;
        Integer n = message.getLastN();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            if (this.lastN != it) {
                this.lastN = it;
                changed = true;
            }
        }
        List<String> list = message.getSelectedSources();
        if (list != null) {
            List<String> it = list;
            boolean bl = false;
            if (!Intrinsics.areEqual(this.selectedSources, it)) {
                this.selectedSources = it;
                changed = true;
            }
        }
        List<String> list2 = message.getOnStageSources();
        if (list2 != null) {
            List<String> it = list2;
            boolean bl = false;
            if (!Intrinsics.areEqual(this.onStageSources, it)) {
                this.onStageSources = it;
                changed = true;
            }
        }
        VideoConstraints videoConstraints = message.getDefaultConstraints();
        if (videoConstraints != null) {
            VideoConstraints it = videoConstraints;
            boolean bl = false;
            if (!Intrinsics.areEqual(this.defaultConstraints, it)) {
                this.defaultConstraints = it;
                changed = true;
            }
        }
        Map<String, VideoConstraints> map = message.getConstraints();
        if (map != null) {
            Map<String, VideoConstraints> it = map;
            boolean bl = false;
            if (!Intrinsics.areEqual(this.videoConstraints, it)) {
                this.videoConstraints = it;
                changed = true;
            }
        }
        Long l = message.getAssumedBandwidthBps();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            Bandwidth bandwidth = BitrateControllerConfig.config.getAssumedBandwidthLimit-4yB3KFE();
            if (bandwidth != null) {
                double limit = bandwidth.unbox-impl();
                boolean bl2 = false;
                long limited = RangesKt.coerceAtMost(it, (long)limit);
                this.logger.warn("Setting assumed bandwidth " + Bandwidth.toString-impl(BandwidthKt.getBps(limited)) + " (receiver asked for " + it + ").");
                this.assumedBandwidthBps = limited;
                changed = true;
            } else {
                this.logger.info("Ignoring assumed-bandwidth-bps, not allowed in config.");
            }
        }
        if (changed) {
            this.allocationSettings = this.create();
        }
        return changed;
    }

    public final boolean setLastN(int lastN) {
        if (this.lastN != lastN) {
            this.lastN = lastN;
            this.allocationSettings = this.create();
            return true;
        }
        return false;
    }

    public AllocationSettingsWrapper() {
        this(null, 1, null);
    }
}

