/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.SendSource;
import org.jitsi.videobridge.SourceDesc;
import org.jitsi.videobridge.SsrcCache;
import org.jitsi.videobridge.SsrcRewriter;
import org.jitsi.videobridge.message.VideoSourceMapping;
import org.jitsi.videobridge.message.VideoSourcesMap;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/videobridge/VideoSsrcCache;", "Lorg/jitsi/videobridge/SsrcCache;", "size", "", "ep", "Lorg/jitsi/videobridge/SsrcRewriter;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(ILorg/jitsi/videobridge/SsrcRewriter;Lorg/jitsi/utils/logging2/Logger;)V", "allowCreateOnPacket", "", "getAllowCreateOnPacket", "()Z", "findSourceProps", "Lorg/jitsi/videobridge/SourceDesc;", "ssrc", "", "notifyMappings", "", "sources", "", "Lorg/jitsi/videobridge/SendSource;", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nSsrcCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SsrcCache.kt\norg/jitsi/videobridge/VideoSsrcCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,718:1\n1#2:719\n1549#3:720\n1620#3,3:721\n*S KotlinDebug\n*F\n+ 1 SsrcCache.kt\norg/jitsi/videobridge/VideoSsrcCache\n*L\n572#1:720\n572#1:721,3\n*E\n"})
public final class VideoSsrcCache
extends SsrcCache {
    private final boolean allowCreateOnPacket;

    public VideoSsrcCache(int size, @NotNull SsrcRewriter ep, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(ep, "ep");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        String string = MediaType.VIDEO.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        super(size, ep, parentLogger, string);
    }

    @Override
    protected boolean getAllowCreateOnPacket() {
        return this.allowCreateOnPacket;
    }

    @Override
    @Nullable
    protected SourceDesc findSourceProps(long ssrc) {
        SourceDesc sourceDesc;
        MediaSourceDesc mediaSourceDesc = this.getEp().findVideoSourceProps(ssrc);
        if (mediaSourceDesc != null) {
            MediaSourceDesc it = mediaSourceDesc;
            boolean bl = false;
            sourceDesc = new SourceDesc(it);
        } else {
            sourceDesc = null;
        }
        return sourceDesc;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void notifyMappings(@NotNull List<SendSource> sources) {
        List list;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sources, "sources");
        Iterable $this$map$iv = sources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SendSource sendSource = (SendSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SourceDesc props = it.getProps();
            collection.add(new VideoSourceMapping(props.getName(), props.getOwner(), it.getSend1().getSsrc(), it.getSend2().getSsrc(), props.getVideoType()));
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        this.getEp().sendMessage(new VideoSourcesMap(it));
    }
}

