/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacket;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacketKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtension;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.videobridge.Av1DDCodecDeltas;
import org.jitsi.videobridge.CodecDeltas;
import org.jitsi.videobridge.CodecState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/videobridge/Av1DDCodecState;", "Lorg/jitsi/videobridge/CodecState;", "lastFrameNum", "", "lastTemplateIdx", "<init>", "(II)V", "packet", "Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;", "(Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;)V", "getLastFrameNum", "()I", "getLastTemplateIdx", "getDeltas", "Lorg/jitsi/videobridge/CodecDeltas;", "otherState", "Lorg/jitsi/rtp/rtp/RtpPacket;", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nSsrcCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SsrcCache.kt\norg/jitsi/videobridge/Av1DDCodecState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,718:1\n1#2:719\n*E\n"})
final class Av1DDCodecState
implements CodecState {
    private final int lastFrameNum;
    private final int lastTemplateIdx;

    public final int getLastFrameNum() {
        return this.lastFrameNum;
    }

    public final int getLastTemplateIdx() {
        return this.lastTemplateIdx;
    }

    public Av1DDCodecState(int lastFrameNum, int lastTemplateIdx) {
        this.lastFrameNum = lastFrameNum;
        this.lastTemplateIdx = lastTemplateIdx;
    }

    public Av1DDCodecState(@NotNull Av1DDPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Av1DependencyDescriptorHeaderExtension descriptor2 = packet.getDescriptor();
        if (descriptor2 == null) {
            boolean bl = false;
            String string = "AV1 Packet being routed must have non-null descriptor";
            throw new IllegalArgumentException(string.toString());
        }
        this.lastFrameNum = packet.getFrameNumber();
        this.lastTemplateIdx = descriptor2.getStructure().getTemplateIdOffset() + descriptor2.getStructure().getTemplateCount();
    }

    @Override
    @Nullable
    public CodecDeltas getDeltas(@Nullable CodecState otherState) {
        if (!(otherState instanceof Av1DDCodecState)) {
            return null;
        }
        int frameNumDelta = RtpUtils.Companion.getSequenceNumberDelta(this.lastFrameNum, ((Av1DDCodecState)otherState).lastFrameNum);
        int templateIdDelta = Av1DDPacketKt.getTemplateIdDelta(this.lastTemplateIdx, ((Av1DDCodecState)otherState).lastTemplateIdx);
        return new Av1DDCodecDeltas(frameNumDelta, templateIdDelta);
    }

    @Override
    @Nullable
    public CodecDeltas getDeltas(@NotNull RtpPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (!(packet instanceof Av1DDPacket)) {
            return null;
        }
        Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension = ((Av1DDPacket)packet).getDescriptor();
        if (av1DependencyDescriptorHeaderExtension == null) {
            return null;
        }
        Av1DependencyDescriptorHeaderExtension descriptor2 = av1DependencyDescriptorHeaderExtension;
        int frameNumDelta = RtpUtils.Companion.getSequenceNumberDelta(this.lastFrameNum, ((Av1DDPacket)packet).getFrameNumber() - 1);
        int packetLastTemplateIdx = descriptor2.getStructure().getTemplateIdOffset() + descriptor2.getStructure().getTemplateCount();
        int templateIdDelta = Av1DDPacketKt.getTemplateIdDelta(this.lastTemplateIdx, packetLastTemplateIdx - 1);
        return new Av1DDCodecDeltas(frameNumDelta, templateIdDelta);
    }
}

