/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.EventListener;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DefaultBoundedRangeModel
implements BoundedRangeModel,
Serializable {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    private int value = 0;
    private int extent = 0;
    private int min = 0;
    private int max = 100;
    private boolean isAdjusting = false;

    public DefaultBoundedRangeModel() {
    }

    public DefaultBoundedRangeModel(int n, int n2, int n3, int n4) {
        if (n4 < n3 || n < n3 || n + n2 < n || n + n2 > n4) {
            throw new IllegalArgumentException("invalid range properties");
        }
        this.value = n;
        this.extent = n2;
        this.min = n3;
        this.max = n4;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public int getExtent() {
        return this.extent;
    }

    @Override
    public int getMinimum() {
        return this.min;
    }

    @Override
    public int getMaximum() {
        return this.max;
    }

    @Override
    public void setValue(int n) {
        int n2 = Math.max(n = Math.min(n, Integer.MAX_VALUE - this.extent), this.min);
        if (n2 + this.extent > this.max) {
            n2 = this.max - this.extent;
        }
        this.setRangeProperties(n2, this.extent, this.min, this.max, this.isAdjusting);
    }

    @Override
    public void setExtent(int n) {
        int n2 = Math.max(0, n);
        if (this.value + n2 > this.max) {
            n2 = this.max - this.value;
        }
        this.setRangeProperties(this.value, n2, this.min, this.max, this.isAdjusting);
    }

    @Override
    public void setMinimum(int n) {
        int n2 = Math.max(n, this.max);
        int n3 = Math.max(n, this.value);
        int n4 = Math.min(n2 - n3, this.extent);
        this.setRangeProperties(n3, n4, n, n2, this.isAdjusting);
    }

    @Override
    public void setMaximum(int n) {
        int n2 = Math.min(n, this.min);
        int n3 = Math.min(n - n2, this.extent);
        int n4 = Math.min(n - n3, this.value);
        this.setRangeProperties(n4, n3, n2, n, this.isAdjusting);
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        this.setRangeProperties(this.value, this.extent, this.min, this.max, bl);
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public void setRangeProperties(int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        if (n3 > n4) {
            n3 = n4;
        }
        if (n > n4) {
            n4 = n;
        }
        if (n < n3) {
            n3 = n;
        }
        if ((long)n2 + (long)n > (long)n4) {
            n2 = n4 - n;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        boolean bl3 = bl2 = n != this.value || n2 != this.extent || n3 != this.min || n4 != this.max || bl != this.isAdjusting;
        if (bl2) {
            this.value = n;
            this.extent = n2;
            this.min = n3;
            this.max = n4;
            this.isAdjusting = bl;
            this.fireStateChanged();
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public String toString() {
        String string = "value=" + this.getValue() + ", extent=" + this.getExtent() + ", min=" + this.getMinimum() + ", max=" + this.getMaximum() + ", adj=" + this.getValueIsAdjusting();
        return this.getClass().getName() + "[" + string + "]";
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }
}

