/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.janino;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.janino.Janino;
import org.pentaho.di.trans.steps.janino.JaninoData;
import org.pentaho.di.trans.steps.janino.JaninoMetaFunction;
import org.pentaho.di.trans.steps.janino.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaninoMeta
extends BaseStepMeta
implements StepMetaInterface {
    private JaninoMetaFunction[] formula;

    public JaninoMetaFunction[] getFormula() {
        return this.formula;
    }

    public void setFormula(JaninoMetaFunction[] calcTypes) {
        this.formula = calcTypes;
    }

    public void allocate(int nrCalcs) {
        this.formula = new JaninoMetaFunction[nrCalcs];
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        int nrCalcs = XMLHandler.countNodes((Node)stepnode, (String)"formula");
        this.allocate(nrCalcs);
        for (int i = 0; i < nrCalcs; ++i) {
            Node calcnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"formula", (int)i);
            this.formula[i] = new JaninoMetaFunction(calcnode);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        if (this.formula != null) {
            for (int i = 0; i < this.formula.length; ++i) {
                retval.append("       " + this.formula[i].getXML() + Const.CR);
            }
        }
        return retval.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            JaninoMeta m = (JaninoMeta)obj;
            return this.getXML() == m.getXML();
        }
        return false;
    }

    @Override
    public Object clone() {
        JaninoMeta retval = (JaninoMeta)super.clone();
        if (this.formula != null) {
            retval.allocate(this.formula.length);
            for (int i = 0; i < this.formula.length; ++i) {
                retval.getFormula()[i] = (JaninoMetaFunction)this.formula[i].clone();
            }
        } else {
            retval.allocate(0);
        }
        return retval;
    }

    @Override
    public void setDefault() {
        this.formula = new JaninoMetaFunction[0];
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        int nrCalcs = rep.countNrStepAttributes(id_step, "field_name");
        this.allocate(nrCalcs);
        for (int i = 0; i < nrCalcs; ++i) {
            this.formula[i] = new JaninoMetaFunction(rep, id_step, i);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        for (int i = 0; i < this.formula.length; ++i) {
            this.formula[i].saveRep(rep, id_transformation, id_step, i);
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        for (int i = 0; i < this.formula.length; ++i) {
            JaninoMetaFunction fn = this.formula[i];
            if (Const.isEmpty((String)fn.getReplaceField())) {
                if (Const.isEmpty((String)fn.getFieldName())) continue;
                ValueMeta v = new ValueMeta(fn.getFieldName(), fn.getValueType());
                v.setLength(fn.getValueLength(), fn.getValuePrecision());
                v.setOrigin(name);
                row.addValueMeta((ValueMetaInterface)v);
                continue;
            }
            int index = row.indexOfValue(fn.getReplaceField());
            if (index < 0) {
                throw new KettleStepException("Unknown field specified to replace with a formula result: [" + fn.getReplaceField() + "]");
            }
            ValueMetaInterface v = row.getValueMeta(index).clone();
            v.setLength(fn.getValueLength(), fn.getValuePrecision());
            v.setOrigin(name);
            row.setValueMeta(index, v);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, Messages.getString("JaninoMeta.CheckResult.ExpectedInputError"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("JaninoMeta.CheckResult.FieldsReceived", "" + prev.size()), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("JaninoMeta.CheckResult.ExpectedInputOk"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("JaninoMeta.CheckResult.ExpectedInputError"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Janino(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new JaninoData();
    }
}

