/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.SetOnce;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.painless.CompilerSettings;
import org.opensearch.painless.PainlessScriptEngine;
import org.opensearch.painless.action.PainlessContextAction;
import org.opensearch.painless.action.PainlessExecuteAction;
import org.opensearch.painless.spi.PainlessExtension;
import org.opensearch.painless.spi.Whitelist;
import org.opensearch.painless.spi.WhitelistLoader;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ExtensiblePlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.IngestScript;
import org.opensearch.script.ScoreScript;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.script.ScriptService;
import org.opensearch.search.aggregations.pipeline.MovingFunctionScript;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

public final class PainlessPlugin
extends Plugin
implements ScriptPlugin,
ExtensiblePlugin,
ActionPlugin {
    private static final Map<ScriptContext<?>, List<Whitelist>> allowlists;
    private final SetOnce<PainlessScriptEngine> painlessScriptEngine = new SetOnce();

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        HashMap contextsWithAllowlists = new HashMap();
        for (ScriptContext<?> context : contexts) {
            List<Whitelist> contextAllowlists = allowlists.get(context);
            if (contextAllowlists == null) {
                contextAllowlists = new ArrayList<Whitelist>(Whitelist.BASE_WHITELISTS);
            }
            contextsWithAllowlists.put(context, contextAllowlists);
        }
        this.painlessScriptEngine.set((Object)new PainlessScriptEngine(settings, contextsWithAllowlists));
        return (ScriptEngine)this.painlessScriptEngine.get();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return Collections.singletonList(this.painlessScriptEngine.get());
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(CompilerSettings.REGEX_ENABLED, CompilerSettings.REGEX_LIMIT_FACTOR);
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        loader.loadExtensions(PainlessExtension.class).stream().flatMap(extension -> extension.getContextWhitelists().entrySet().stream()).forEach(entry -> {
            List existing = allowlists.computeIfAbsent((ScriptContext)entry.getKey(), c -> new ArrayList(Whitelist.BASE_WHITELISTS));
            existing.addAll((Collection)entry.getValue());
        });
    }

    public List<ScriptContext<?>> getContexts() {
        return Collections.singletonList(PainlessExecuteAction.PainlessTestScript.CONTEXT);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        actions.add(new ActionPlugin.ActionHandler((ActionType)PainlessExecuteAction.INSTANCE, PainlessExecuteAction.TransportAction.class, new Class[0]));
        actions.add(new ActionPlugin.ActionHandler((ActionType)PainlessContextAction.INSTANCE, PainlessContextAction.TransportAction.class, new Class[0]));
        return actions;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new PainlessExecuteAction.RestAction());
        handlers.add((RestHandler)new PainlessContextAction.RestAction());
        return handlers;
    }

    static {
        HashMap map = new HashMap();
        ArrayList<Whitelist> movFn = new ArrayList<Whitelist>(Whitelist.BASE_WHITELISTS);
        movFn.add(WhitelistLoader.loadFromResourceFiles(Whitelist.class, (String[])new String[]{"org.opensearch.aggs.movfn.txt"}));
        map.put(MovingFunctionScript.CONTEXT, movFn);
        ArrayList<Whitelist> scoreFn = new ArrayList<Whitelist>(Whitelist.BASE_WHITELISTS);
        scoreFn.add(WhitelistLoader.loadFromResourceFiles(Whitelist.class, (String[])new String[]{"org.opensearch.score.txt"}));
        map.put(ScoreScript.CONTEXT, scoreFn);
        ArrayList<Whitelist> ingest = new ArrayList<Whitelist>(Whitelist.BASE_WHITELISTS);
        ingest.add(WhitelistLoader.loadFromResourceFiles(Whitelist.class, (String[])new String[]{"org.opensearch.ingest.txt"}));
        map.put(IngestScript.CONTEXT, ingest);
        allowlists = map;
    }
}

