/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.index;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionFuture;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.opensearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.cluster.metadata.Template;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.component.LifecycleListener;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.settings.Settings;
import org.opensearch.observability.settings.PluginSettings;
import org.opensearch.observability.util.HelpersKt;
import org.opensearch.observability.util.SecureIndexClient;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/observability/index/ObservabilityTracesIndex;", "Lorg/opensearch/common/component/LifecycleListener;", "()V", "TRACES_MAPPING_TEMPLATE_FILE", "", "TRACES_MAPPING_TEMPLATE_NAME", "TRACES_PATTERN_NAME", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "afterStart", "", "createMappingTemplate", "initialize", "isTemplateExists", "", "template", "opensearch-observability"})
public final class ObservabilityTracesIndex
extends LifecycleListener {
    @NotNull
    public static final ObservabilityTracesIndex INSTANCE = new ObservabilityTracesIndex();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ObservabilityTracesIndex.class);
    @NotNull
    private static final String TRACES_MAPPING_TEMPLATE_NAME = "sso_trace_template";
    @NotNull
    private static final String TRACES_MAPPING_TEMPLATE_FILE = "traces-mapping-template.json";
    @NotNull
    private static final String TRACES_PATTERN_NAME = "sso_traces-*-*";
    private static Client client;
    private static ClusterService clusterService;

    private ObservabilityTracesIndex() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final ObservabilityTracesIndex initialize(@NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        ObservabilityTracesIndex.client = new SecureIndexClient(client);
        ObservabilityTracesIndex.clusterService = clusterService;
        return this;
    }

    public void afterStart() {
        this.createMappingTemplate();
    }

    private final void createMappingTemplate() {
        block9: {
            this.getLog().info("observability:createMappingTemplate sso_trace_template API called");
            if (!this.isTemplateExists(TRACES_MAPPING_TEMPLATE_NAME)) {
                String string;
                ClassLoader classLoader = ObservabilityTracesIndex.class.getClassLoader();
                URL uRL = classLoader.getResource(TRACES_MAPPING_TEMPLATE_FILE);
                if (uRL == null) {
                    string = null;
                } else {
                    URL uRL2 = uRL;
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                    string = new String(byArray, charset);
                }
                Intrinsics.checkNotNull(string);
                String indexMappingSource = string;
                Settings settings = Settings.builder().put("index.number_of_shards", 3).put("index.auto_expand_replicas", "0-2").build();
                Template template = new Template(settings, new CompressedXContent(indexMappingSource), null);
                PutComposableIndexTemplateAction.Request request = new PutComposableIndexTemplateAction.Request(TRACES_MAPPING_TEMPLATE_NAME).indexTemplate(new ComposableIndexTemplate(CollectionsKt.listOf((Object)TRACES_PATTERN_NAME), template, Collections.emptyList(), Long.valueOf(1L), Long.valueOf(1L), Collections.singletonMap("description", "Observability Traces Mapping Template"), new ComposableIndexTemplate.DataStreamTemplate()));
                try {
                    ActionFuture actionFuture;
                    AcknowledgedResponse response;
                    ActionRequestValidationException validationException = request.validateIndexTemplate(null);
                    if (validationException != null && !validationException.validationErrors().isEmpty()) {
                        throw new IllegalStateException(("observability:Index Template sso_trace_template validation errors " + validationException.getMessage()).toString());
                    }
                    Client client = ObservabilityTracesIndex.client;
                    if (client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        client = null;
                    }
                    if (!(response = (AcknowledgedResponse)(actionFuture = client.admin().indices().execute((ActionType)PutComposableIndexTemplateAction.INSTANCE, (ActionRequest)request)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).isAcknowledged()) {
                        throw new IllegalStateException("observability:Mapping Template sso_trace_template creation not Acknowledged".toString());
                    }
                    this.getLog().info("observability:Mapping Template sso_trace_template creation Acknowledged");
                }
                catch (ResourceAlreadyExistsException exception) {
                    this.getLog().warn("message: " + exception.getMessage());
                }
                catch (Exception exception) {
                    if (exception.getCause() instanceof ResourceAlreadyExistsException) break block9;
                    throw exception;
                }
            }
        }
    }

    private final boolean isTemplateExists(String template) {
        try {
            Client client = ObservabilityTracesIndex.client;
            if (client == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                client = null;
            }
            IndicesAdminClient indices = client.admin().indices();
            Object object = new String[]{template};
            GetIndexTemplatesResponse response = (GetIndexTemplatesResponse)indices.getTemplates(new GetIndexTemplatesRequest(object)).get();
            object = response.getIndexTemplates();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.indexTemplates");
            return !((Collection)object).isEmpty();
        }
        catch (ResourceNotFoundException exception) {
            return false;
        }
        catch (ResourceAlreadyExistsException exception) {
            return true;
        }
        catch (Exception exception) {
            throw exception;
        }
    }
}

