/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.onnxruntime.engine;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.engine.Engine;
import ai.djl.ndarray.NDManager;
import ai.djl.nn.SymbolBlock;
import ai.djl.onnxruntime.engine.OrtModel;
import ai.djl.onnxruntime.engine.OrtNDManager;
import ai.djl.training.GradientCollector;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;

public final class OrtEngine
extends Engine {
    public static final String ENGINE_NAME = "OnnxRuntime";
    static final int RANK = 10;
    private OrtEnvironment env = OrtEnvironment.getEnvironment();
    private Engine alternativeEngine;
    private boolean initialized;

    private OrtEngine() {
    }

    static Engine newInstance() {
        return new OrtEngine();
    }

    public Engine getAlternativeEngine() {
        if (!this.initialized && !Boolean.getBoolean("ai.djl.onnx.disable_alternative")) {
            Engine engine = Engine.getInstance();
            if (engine.getRank() < this.getRank()) {
                this.alternativeEngine = engine;
            }
            this.initialized = true;
        }
        return this.alternativeEngine;
    }

    public String getEngineName() {
        return ENGINE_NAME;
    }

    public int getRank() {
        return 10;
    }

    public String getVersion() {
        return "1.12.1";
    }

    public boolean hasCapability(String capability) {
        if ("MKL".equals(capability)) {
            return true;
        }
        if ("CUDA".equals(capability)) {
            try {
                OrtSession.SessionOptions sessionOptions = new OrtSession.SessionOptions();
                sessionOptions.addCUDA();
                return true;
            }
            catch (OrtException e) {
                return false;
            }
        }
        return false;
    }

    public Model newModel(String name, Device device) {
        return new OrtModel(name, this.newBaseManager(device), this.env);
    }

    public SymbolBlock newSymbolBlock(NDManager manager) {
        throw new UnsupportedOperationException("ONNXRuntime does not support empty SymbolBlock");
    }

    public NDManager newBaseManager() {
        return this.newBaseManager(null);
    }

    public NDManager newBaseManager(Device device) {
        return OrtNDManager.getSystemManager().newSubManager(device);
    }

    public GradientCollector newGradientCollector() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public void setRandomSeed(int seed) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getEngineName()).append(':').append(this.getVersion()).append(", ");
        sb.append(this.getEngineName()).append(':').append(this.getVersion()).append(", capabilities: [\n\tMKL,\n");
        if (this.hasCapability("CUDA")) {
            sb.append("\t").append("CUDA").append(",\n");
        }
        return sb.toString();
    }
}

