/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.util;

import java.util.function.BiConsumer;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.ActionType;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.util.ADSafeSecurityInjector;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;

public class SecurityClientUtil {
    private static final String INJECTION_ID = "direct";
    private NodeStateManager nodeStateManager;
    private Settings settings;

    @Inject
    public SecurityClientUtil(NodeStateManager nodeStateManager, Settings settings) {
        this.nodeStateManager = nodeStateManager;
        this.settings = settings;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void asyncRequestWithInjectedSecurity(Request request, BiConsumer<Request, ActionListener<Response>> consumer, String detectorId, Client client, ActionListener<Response> listener) {
        ThreadContext threadContext = client.threadPool().getThreadContext();
        try (ADSafeSecurityInjector injectSecurity = new ADSafeSecurityInjector(detectorId, this.settings, threadContext, this.nodeStateManager);){
            injectSecurity.injectUserRolesFromDetector((ActionListener<Void>)ActionListener.wrap(success -> consumer.accept(request, ActionListener.runBefore((ActionListener)listener, () -> injectSecurity.close())), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void asyncRequestWithInjectedSecurity(Request request, BiConsumer<Request, ActionListener<Response>> consumer, User user, Client client, ActionListener<Response> listener) {
        ThreadContext threadContext = client.threadPool().getThreadContext();
        try (ADSafeSecurityInjector injectSecurity = new ADSafeSecurityInjector(INJECTION_ID, this.settings, threadContext, this.nodeStateManager);){
            injectSecurity.injectUserRoles(user);
            consumer.accept(request, ActionListener.runBefore(listener, () -> injectSecurity.close()));
        }
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void executeWithInjectedSecurity(ActionType<Response> action, Request request, User user, Client client, ActionListener<Response> listener) {
        ThreadContext threadContext = client.threadPool().getThreadContext();
        try (ADSafeSecurityInjector injectSecurity = new ADSafeSecurityInjector(INJECTION_ID, this.settings, threadContext, this.nodeStateManager);){
            injectSecurity.injectUserRoles(user);
            client.execute(action, request, ActionListener.runBefore(listener, () -> injectSecurity.close()));
        }
    }
}

