/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.AnomalyDetectorProfileRunner;
import org.opensearch.ad.EntityProfileRunner;
import org.opensearch.ad.Name;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskType;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyDetectorJob;
import org.opensearch.ad.model.DetectorProfile;
import org.opensearch.ad.model.DetectorProfileName;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.model.EntityProfile;
import org.opensearch.ad.model.EntityProfileName;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.GetAnomalyDetectorAction;
import org.opensearch.ad.transport.GetAnomalyDetectorRequest;
import org.opensearch.ad.transport.GetAnomalyDetectorResponse;
import org.opensearch.ad.util.DiscoveryNodeFilterer;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.ad.util.SecurityClientUtil;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.Strings;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.authuser.User;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetAnomalyDetectorTransportAction
extends HandledTransportAction<GetAnomalyDetectorRequest, GetAnomalyDetectorResponse> {
    private static final Logger LOG = LogManager.getLogger(GetAnomalyDetectorTransportAction.class);
    private final ClusterService clusterService;
    private final Client client;
    private final SecurityClientUtil clientUtil;
    private final Set<String> allProfileTypeStrs;
    private final Set<DetectorProfileName> allProfileTypes;
    private final Set<DetectorProfileName> defaultDetectorProfileTypes;
    private final Set<String> allEntityProfileTypeStrs;
    private final Set<EntityProfileName> allEntityProfileTypes;
    private final Set<EntityProfileName> defaultEntityProfileTypes;
    private final NamedXContentRegistry xContentRegistry;
    private final DiscoveryNodeFilterer nodeFilter;
    private final TransportService transportService;
    private volatile Boolean filterByEnabled;
    private final ADTaskManager adTaskManager;

    @Inject
    public GetAnomalyDetectorTransportAction(TransportService transportService, DiscoveryNodeFilterer nodeFilter, ActionFilters actionFilters, ClusterService clusterService, Client client, SecurityClientUtil clientUtil, Settings settings, NamedXContentRegistry xContentRegistry, ADTaskManager adTaskManager) {
        super(GetAnomalyDetectorAction.NAME, transportService, actionFilters, GetAnomalyDetectorRequest::new);
        this.clusterService = clusterService;
        this.client = client;
        this.clientUtil = clientUtil;
        List<DetectorProfileName> allProfiles = Arrays.asList(DetectorProfileName.values());
        this.allProfileTypes = EnumSet.copyOf(allProfiles);
        this.allProfileTypeStrs = this.getProfileListStrs(allProfiles);
        List<DetectorProfileName> defaultProfiles = Arrays.asList(DetectorProfileName.ERROR, DetectorProfileName.STATE);
        this.defaultDetectorProfileTypes = new HashSet<DetectorProfileName>(defaultProfiles);
        List<EntityProfileName> allEntityProfiles = Arrays.asList(EntityProfileName.values());
        this.allEntityProfileTypes = EnumSet.copyOf(allEntityProfiles);
        this.allEntityProfileTypeStrs = this.getProfileListStrs(allEntityProfiles);
        List<EntityProfileName> defaultEntityProfiles = Arrays.asList(EntityProfileName.STATE);
        this.defaultEntityProfileTypes = new HashSet<EntityProfileName>(defaultEntityProfiles);
        this.xContentRegistry = xContentRegistry;
        this.nodeFilter = nodeFilter;
        this.filterByEnabled = (Boolean)AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
        this.transportService = transportService;
        this.adTaskManager = adTaskManager;
    }

    protected void doExecute(Task task, GetAnomalyDetectorRequest request, ActionListener<GetAnomalyDetectorResponse> actionListener) {
        String detectorID = request.getDetectorID();
        User user = ParseUtils.getUserContext(this.client);
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, CommonErrorMessages.FAIL_TO_GET_DETECTOR);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ParseUtils.resolveUserAndExecute(user, detectorID, this.filterByEnabled, listener, anomalyDetector -> this.getExecute(request, (ActionListener<GetAnomalyDetectorResponse>)listener), this.client, this.clusterService, this.xContentRegistry);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            listener.onFailure(e);
        }
    }

    protected void getExecute(GetAnomalyDetectorRequest request, ActionListener<GetAnomalyDetectorResponse> listener) {
        String detectorID = request.getDetectorID();
        String typesStr = request.getTypeStr();
        String rawPath = request.getRawPath();
        Entity entity = request.getEntity();
        boolean all = request.isAll();
        boolean returnJob = request.isReturnJob();
        boolean returnTask = request.isReturnTask();
        try {
            if (!Strings.isEmpty((CharSequence)typesStr) || rawPath.endsWith("_profile") || rawPath.endsWith("_profile/")) {
                if (entity != null) {
                    Set<EntityProfileName> entityProfilesToCollect = this.getEntityProfilesToCollect(typesStr, all);
                    EntityProfileRunner profileRunner = new EntityProfileRunner(this.client, this.clientUtil, this.xContentRegistry, 32L);
                    profileRunner.profile(detectorID, entity, entityProfilesToCollect, (ActionListener<EntityProfile>)ActionListener.wrap(profile -> listener.onResponse((Object)new GetAnomalyDetectorResponse(0L, null, 0L, 0L, null, null, false, null, null, false, null, null, (EntityProfile)profile, true)), e -> listener.onFailure(e)));
                } else {
                    Set<DetectorProfileName> profilesToCollect = this.getProfilesToCollect(typesStr, all);
                    AnomalyDetectorProfileRunner profileRunner = new AnomalyDetectorProfileRunner(this.client, this.clientUtil, this.xContentRegistry, this.nodeFilter, 32L, this.transportService, this.adTaskManager);
                    profileRunner.profile(detectorID, this.getProfileActionListener(listener), profilesToCollect);
                }
            } else if (returnTask) {
                this.adTaskManager.getAndExecuteOnLatestADTasks(detectorID, null, null, ADTaskType.ALL_DETECTOR_TASK_TYPES, taskList -> {
                    Optional<ADTask> realtimeAdTask = Optional.empty();
                    Optional<ADTask> historicalAdTask = Optional.empty();
                    if (taskList != null && taskList.size() > 0) {
                        HashMap<String, ADTask> adTasks = new HashMap<String, ADTask>();
                        ArrayList<ADTask> duplicateAdTasks = new ArrayList<ADTask>();
                        for (ADTask task : taskList) {
                            if (adTasks.containsKey(task.getTaskType())) {
                                LOG.info("Found duplicate latest task of detector {}, task id: {}, task type: {}", (Object)detectorID, (Object)task.getTaskType(), (Object)task.getTaskId());
                                duplicateAdTasks.add(task);
                                continue;
                            }
                            adTasks.put(task.getTaskType(), task);
                        }
                        if (duplicateAdTasks.size() > 0) {
                            this.adTaskManager.resetLatestFlagAsFalse(duplicateAdTasks);
                        }
                        if (adTasks.containsKey(ADTaskType.REALTIME_HC_DETECTOR.name())) {
                            realtimeAdTask = Optional.ofNullable((ADTask)adTasks.get(ADTaskType.REALTIME_HC_DETECTOR.name()));
                        } else if (adTasks.containsKey(ADTaskType.REALTIME_SINGLE_ENTITY.name())) {
                            realtimeAdTask = Optional.ofNullable((ADTask)adTasks.get(ADTaskType.REALTIME_SINGLE_ENTITY.name()));
                        }
                        if (adTasks.containsKey(ADTaskType.HISTORICAL_HC_DETECTOR.name())) {
                            historicalAdTask = Optional.ofNullable((ADTask)adTasks.get(ADTaskType.HISTORICAL_HC_DETECTOR.name()));
                        } else if (adTasks.containsKey(ADTaskType.HISTORICAL_SINGLE_ENTITY.name())) {
                            historicalAdTask = Optional.ofNullable((ADTask)adTasks.get(ADTaskType.HISTORICAL_SINGLE_ENTITY.name()));
                        } else if (adTasks.containsKey(ADTaskType.HISTORICAL.name())) {
                            historicalAdTask = Optional.ofNullable((ADTask)adTasks.get(ADTaskType.HISTORICAL.name()));
                        }
                    }
                    this.getDetectorAndJob(detectorID, returnJob, returnTask, realtimeAdTask, historicalAdTask, listener);
                }, this.transportService, true, 2, listener);
            } else {
                this.getDetectorAndJob(detectorID, returnJob, returnTask, Optional.empty(), Optional.empty(), listener);
            }
        }
        catch (Exception e2) {
            LOG.error((Object)e2);
            listener.onFailure(e2);
        }
    }

    private void getDetectorAndJob(String detectorID, boolean returnJob, boolean returnTask, Optional<ADTask> realtimeAdTask, Optional<ADTask> historicalAdTask, ActionListener<GetAnomalyDetectorResponse> listener) {
        MultiGetRequest.Item adItem = new MultiGetRequest.Item(".opendistro-anomaly-detectors", detectorID);
        MultiGetRequest multiGetRequest = new MultiGetRequest().add(adItem);
        if (returnJob) {
            MultiGetRequest.Item adJobItem = new MultiGetRequest.Item(".opendistro-anomaly-detector-jobs", detectorID);
            multiGetRequest.add(adJobItem);
        }
        this.client.multiGet(multiGetRequest, this.onMultiGetResponse(listener, returnJob, returnTask, realtimeAdTask, historicalAdTask, detectorID));
    }

    private ActionListener<MultiGetResponse> onMultiGetResponse(final ActionListener<GetAnomalyDetectorResponse> listener, final boolean returnJob, final boolean returnTask, final Optional<ADTask> realtimeAdTask, final Optional<ADTask> historicalAdTask, final String detectorId) {
        return new ActionListener<MultiGetResponse>(){

            public void onResponse(MultiGetResponse multiGetResponse) {
                MultiGetItemResponse[] responses = multiGetResponse.getResponses();
                AnomalyDetector detector = null;
                AnomalyDetectorJob adJob = null;
                String id = null;
                long version = 0L;
                long seqNo = 0L;
                long primaryTerm = 0L;
                for (MultiGetItemResponse response : responses) {
                    XContentParser parser;
                    if (".opendistro-anomaly-detectors".equals(response.getIndex())) {
                        if (response.getResponse() == null || !response.getResponse().isExists()) {
                            listener.onFailure((Exception)new OpenSearchStatusException(CommonErrorMessages.FAIL_TO_FIND_DETECTOR_MSG + detectorId, RestStatus.NOT_FOUND, new Object[0]));
                            return;
                        }
                        id = response.getId();
                        version = response.getResponse().getVersion();
                        primaryTerm = response.getResponse().getPrimaryTerm();
                        seqNo = response.getResponse().getSeqNo();
                        if (!response.getResponse().isSourceEmpty()) {
                            try {
                                parser = RestHandlerUtils.createXContentParserFromRegistry(GetAnomalyDetectorTransportAction.this.xContentRegistry, response.getResponse().getSourceAsBytesRef());
                                try {
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    detector = (AnomalyDetector)parser.namedObject(AnomalyDetector.class, "AnomalyDetector", null);
                                }
                                finally {
                                    if (parser != null) {
                                        parser.close();
                                    }
                                }
                            }
                            catch (Exception e) {
                                String message = "Failed to parse detector job " + detectorId;
                                listener.onFailure((Exception)GetAnomalyDetectorTransportAction.this.buildInternalServerErrorResponse(e, message));
                                return;
                            }
                        }
                    }
                    if (!".opendistro-anomaly-detector-jobs".equals(response.getIndex()) || response.getResponse() == null || !response.getResponse().isExists() || response.getResponse().isSourceEmpty()) continue;
                    try {
                        parser = RestHandlerUtils.createXContentParserFromRegistry(GetAnomalyDetectorTransportAction.this.xContentRegistry, response.getResponse().getSourceAsBytesRef());
                        try {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                            adJob = AnomalyDetectorJob.parse(parser);
                        }
                        finally {
                            if (parser != null) {
                                parser.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        String message = "Failed to parse detector job " + detectorId;
                        listener.onFailure((Exception)GetAnomalyDetectorTransportAction.this.buildInternalServerErrorResponse(e, message));
                        return;
                    }
                }
                listener.onResponse((Object)new GetAnomalyDetectorResponse(version, id, primaryTerm, seqNo, detector, adJob, returnJob, realtimeAdTask.orElse(null), historicalAdTask.orElse(null), returnTask, RestStatus.OK, null, null, false));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
    }

    private ActionListener<DetectorProfile> getProfileActionListener(final ActionListener<GetAnomalyDetectorResponse> listener) {
        return ActionListener.wrap((CheckedConsumer)new CheckedConsumer<DetectorProfile, Exception>(){

            public void accept(DetectorProfile profile) throws Exception {
                listener.onResponse((Object)new GetAnomalyDetectorResponse(0L, null, 0L, 0L, null, null, false, null, null, false, null, profile, null, true));
            }
        }, exception -> listener.onFailure(exception));
    }

    private OpenSearchStatusException buildInternalServerErrorResponse(Exception e, String errorMsg) {
        LOG.error(errorMsg, (Throwable)e);
        return new OpenSearchStatusException(errorMsg, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
    }

    private Set<DetectorProfileName> getProfilesToCollect(String typesStr, boolean all) {
        if (all) {
            return this.allProfileTypes;
        }
        if (Strings.isEmpty((CharSequence)typesStr)) {
            return this.defaultDetectorProfileTypes;
        }
        HashSet<String> typesInRequest = new HashSet<String>(Arrays.asList(typesStr.split(",")));
        return DetectorProfileName.getNames((Collection<String>)Sets.intersection(this.allProfileTypeStrs, typesInRequest));
    }

    private Set<EntityProfileName> getEntityProfilesToCollect(String typesStr, boolean all) {
        if (all) {
            return this.allEntityProfileTypes;
        }
        if (Strings.isEmpty((CharSequence)typesStr)) {
            return this.defaultEntityProfileTypes;
        }
        HashSet<String> typesInRequest = new HashSet<String>(Arrays.asList(typesStr.split(",")));
        return EntityProfileName.getNames((Collection<String>)Sets.intersection(this.allEntityProfileTypeStrs, typesInRequest));
    }

    private Set<String> getProfileListStrs(List<? extends Name> profileList) {
        return profileList.stream().map(profile -> profile.getName()).collect(Collectors.toSet());
    }
}

