/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ratelimit;

import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.support.ThreadedActionListener;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.breaker.ADCircuitBreakerService;
import org.opensearch.ad.ratelimit.ConcurrentWorker;
import org.opensearch.ad.ratelimit.QueuedRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.threadpool.ThreadPool;

public abstract class BatchWorker<RequestType extends QueuedRequest, BatchRequestType, BatchResponseType>
extends ConcurrentWorker<RequestType> {
    private static final Logger LOG = LogManager.getLogger(BatchWorker.class);
    protected int batchSize;

    public BatchWorker(String queueName, long heapSize, int singleRequestSize, Setting<Float> maxHeapPercentForQueueSetting, ClusterService clusterService, Random random, ADCircuitBreakerService adCircuitBreakerService, ThreadPool threadPool, Settings settings, float maxQueuedTaskRatio, Clock clock, float mediumSegmentPruneRatio, float lowSegmentPruneRatio, int maintenanceFreqConstant, Setting<Integer> concurrencySetting, Duration executionTtl, Setting<Integer> batchSizeSetting, Duration stateTtl, NodeStateManager nodeStateManager) {
        super(queueName, heapSize, singleRequestSize, maxHeapPercentForQueueSetting, clusterService, random, adCircuitBreakerService, threadPool, settings, maxQueuedTaskRatio, clock, mediumSegmentPruneRatio, lowSegmentPruneRatio, maintenanceFreqConstant, concurrencySetting, executionTtl, stateTtl, nodeStateManager);
        this.batchSize = (Integer)batchSizeSetting.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(batchSizeSetting, it -> {
            this.batchSize = it;
        });
    }

    protected abstract void executeBatchRequest(BatchRequestType var1, ActionListener<BatchResponseType> var2);

    protected abstract BatchRequestType toBatchRequest(List<RequestType> var1);

    @Override
    protected void execute(Runnable afterProcessCallback, Runnable emptyQueueCallback) {
        List toProcess = this.getRequests(this.batchSize);
        if (!toProcess.isEmpty()) {
            BatchRequestType batchRequest = this.toBatchRequest(toProcess);
            ThreadedActionListener listener = new ThreadedActionListener(LOG, this.threadPool, "ad-threadpool", this.getResponseListener(toProcess, batchRequest), false);
            ActionListener listenerWithRelease = ActionListener.runAfter((ActionListener)listener, (Runnable)afterProcessCallback);
            this.executeBatchRequest(batchRequest, listenerWithRelease);
        } else {
            emptyQueueCallback.run();
        }
    }

    protected abstract ActionListener<BatchResponseType> getResponseListener(List<RequestType> var1, BatchRequestType var2);
}

