/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.action.GetAlertsRequest;
import org.opensearch.securityanalytics.action.GetAlertsResponse;
import org.opensearch.securityanalytics.action.SearchDetectorRequest;
import org.opensearch.securityanalytics.alerts.AlertsService;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.transport.TransportSearchDetectorAction;
import org.opensearch.securityanalytics.util.DetectorUtils;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportGetAlertsAction
extends HandledTransportAction<GetAlertsRequest, GetAlertsResponse>
implements SecureTransportAction {
    private final TransportSearchDetectorAction transportSearchDetectorAction;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final Settings settings;
    private final ThreadPool threadPool;
    private final AlertsService alertsService;
    private volatile Boolean filterByEnabled;
    private static final Logger log = LogManager.getLogger(TransportGetAlertsAction.class);

    @Inject
    public TransportGetAlertsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, TransportSearchDetectorAction transportSearchDetectorAction, ThreadPool threadPool, Settings settings, NamedXContentRegistry xContentRegistry, Client client) {
        super("cluster:admin/opensearch/securityanalytics/alerts/get", transportService, actionFilters, GetAlertsRequest::new);
        this.transportSearchDetectorAction = transportSearchDetectorAction;
        this.xContentRegistry = xContentRegistry;
        this.alertsService = new AlertsService(client);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.settings = settings;
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, this::setFilterByEnabled);
    }

    protected void doExecute(Task task, final GetAlertsRequest request, final ActionListener<GetAlertsResponse> actionListener) {
        User user = this.readUserFromThreadContext(this.threadPool);
        String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
        if (!"".equals(validateBackendRoleMessage)) {
            actionListener.onFailure((Exception)new OpenSearchStatusException("Do not have permissions to resource", RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        if (request.getDetectorType() == null) {
            this.alertsService.getAlertsByDetectorId(request.getDetectorId(), request.getTable(), request.getSeverityLevel(), request.getAlertState(), actionListener);
        } else {
            NestedQueryBuilder queryBuilder = QueryBuilders.nestedQuery((String)"detector", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"detector.detector_type", (Object)request.getDetectorType().getDetectorType())), (ScoreMode)ScoreMode.None);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(true);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{".opensearch-sap-detectors-config"});
            searchRequest.source(searchSourceBuilder);
            this.transportSearchDetectorAction.execute(new SearchDetectorRequest(searchRequest), (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse searchResponse) {
                    try {
                        List<Detector> detectors = DetectorUtils.getDetectors(searchResponse, TransportGetAlertsAction.this.xContentRegistry);
                        if (detectors.size() == 0) {
                            actionListener.onFailure((Exception)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("No detectors found for provided type", RestStatus.NOT_FOUND, new Object[0])));
                            return;
                        }
                        TransportGetAlertsAction.this.alertsService.getAlerts(detectors, request.getDetectorType(), request.getTable(), request.getSeverityLevel(), request.getAlertState(), (ActionListener<GetAlertsResponse>)actionListener);
                    }
                    catch (IOException e) {
                        actionListener.onFailure((Exception)e);
                    }
                }

                public void onFailure(Exception e) {
                    actionListener.onFailure(e);
                }
            });
        }
    }

    private void setFilterByEnabled(boolean filterByEnabled) {
        this.filterByEnabled = filterByEnabled;
    }
}

