/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.action.DeleteDetectorAction;
import org.opensearch.securityanalytics.action.DeleteDetectorRequest;

public class RestDeleteDetectorAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestDeleteDetectorAction.class);

    public String getName() {
        return "delete_detector_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.getDefault(), "%s/{%s}", "/_plugins/_security_analytics/detectors", "detector_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.getDefault(), "%s %s/{%s}", request.method(), "/_plugins/_security_analytics/detectors", "detector_id"));
        String detectorId = request.param("detector_id");
        WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.parse((String)request.param("refresh", WriteRequest.RefreshPolicy.IMMEDIATE.getValue()));
        DeleteDetectorRequest deleteDetectorRequest = new DeleteDetectorRequest(detectorId, refreshPolicy);
        return channel -> client.execute((ActionType)DeleteDetectorAction.INSTANCE, (ActionRequest)deleteDetectorRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

