/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.model.DetectorRule;

public class DetectorInput
implements Writeable,
ToXContentObject {
    private String description;
    private List<String> indices;
    private List<DetectorRule> customRules;
    private List<DetectorRule> prePackagedRules;
    private static final String NO_DESCRIPTION = "";
    protected static final String DESCRIPTION_FIELD = "description";
    protected static final String INDICES_FIELD = "indices";
    private static final String DETECTOR_INPUT_FIELD = "detector_input";
    protected static final String CUSTOM_RULES_FIELD = "custom_rules";
    protected static final String PREPACKAGED_RULES_FIELD = "pre_packaged_rules";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(DetectorInput.class, new ParseField("detector_input", new String[0]), DetectorInput::parse);

    public DetectorInput(String description, List<String> indices, List<DetectorRule> customRules, List<DetectorRule> prePackagedRules) {
        this.description = description;
        this.indices = indices;
        this.customRules = customRules;
        this.prePackagedRules = prePackagedRules;
    }

    public DetectorInput(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readStringList(), sin.readList(DetectorRule::new), sin.readList(DetectorRule::new));
    }

    public Map<String, Object> asTemplateArg() {
        return Map.of(DESCRIPTION_FIELD, this.description, INDICES_FIELD, this.indices, CUSTOM_RULES_FIELD, this.customRules.stream().map(DetectorRule::asTemplateArg).collect(Collectors.toList()), PREPACKAGED_RULES_FIELD, this.prePackagedRules.stream().map(DetectorRule::asTemplateArg).collect(Collectors.toList()));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.description);
        out.writeStringCollection(this.indices);
        out.writeCollection(this.customRules);
        out.writeCollection(this.prePackagedRules);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        String[] indicesArray = new String[]{};
        indicesArray = this.indices.toArray(indicesArray);
        DetectorRule[] customRulesArray = new DetectorRule[]{};
        customRulesArray = this.customRules.toArray(customRulesArray);
        DetectorRule[] prePackagedRulesArray = new DetectorRule[]{};
        prePackagedRulesArray = this.prePackagedRules.toArray(prePackagedRulesArray);
        builder.startObject().startObject(DETECTOR_INPUT_FIELD).field(DESCRIPTION_FIELD, this.description).field(INDICES_FIELD, (Object)indicesArray).field(CUSTOM_RULES_FIELD, (Object)customRulesArray).field(PREPACKAGED_RULES_FIELD, (Object)prePackagedRulesArray).endObject().endObject();
        return builder;
    }

    public static DetectorInput parse(XContentParser xcp) throws IOException {
        String description = NO_DESCRIPTION;
        ArrayList<String> indices = new ArrayList<String>();
        ArrayList<DetectorRule> customRules = new ArrayList<DetectorRule>();
        ArrayList<DetectorRule> prePackagedRules = new ArrayList<DetectorRule>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "description": {
                    description = xcp.text();
                    break;
                }
                case "indices": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        indices.add(xcp.text());
                    }
                    break;
                }
                case "custom_rules": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        customRules.add(DetectorRule.parse(xcp));
                    }
                    break;
                }
                case "pre_packaged_rules": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        prePackagedRules.add(DetectorRule.parse(xcp));
                    }
                    break;
                }
            }
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        return new DetectorInput(description, indices, customRules, prePackagedRules);
    }

    public static DetectorInput readFrom(StreamInput sin) throws IOException {
        return new DetectorInput(sin);
    }

    public void setCustomRules(List<DetectorRule> customRules) {
        this.customRules = customRules;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public List<DetectorRule> getCustomRules() {
        return this.customRules;
    }

    public List<DetectorRule> getPrePackagedRules() {
        return this.prePackagedRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetectorInput input = (DetectorInput)o;
        return Objects.equals(this.description, input.description) && Objects.equals(this.indices, input.indices) && Objects.equals(this.customRules, input.customRules) && Objects.equals(this.prePackagedRules, input.prePackagedRules);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.indices, this.customRules, this.prePackagedRules);
    }
}

