/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionResponse;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;

public class ValidateRulesResponse
extends ActionResponse
implements ToXContentObject {
    private Logger logger = LogManager.getLogger(ValidateRulesResponse.class);
    public static final String NONAPPLICABLE_FIELDS = "nonapplicable_fields";
    List<String> nonapplicableFields;

    public ValidateRulesResponse(List<String> nonapplicableFields) {
        this.nonapplicableFields = nonapplicableFields;
    }

    public ValidateRulesResponse(StreamInput in) throws IOException {
        super(in);
        this.nonapplicableFields = in.readStringList();
        int size = in.readVInt();
        if (size > 0) {
            this.nonapplicableFields = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                this.nonapplicableFields.add(in.readString());
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.nonapplicableFields != null) {
            out.writeVInt(this.nonapplicableFields.size());
            for (String f : this.nonapplicableFields) {
                out.writeString(f);
            }
        } else {
            out.writeVInt(0);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.nonapplicableFields != null && this.nonapplicableFields.size() > 0) {
            builder.field(NONAPPLICABLE_FIELDS, this.nonapplicableFields);
        }
        return builder.endObject();
    }

    public List<String> getNonapplicableFields() {
        return this.nonapplicableFields;
    }

    public String toString() {
        try {
            return Strings.toString((XContentBuilder)this.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return "";
        }
    }

    public int hashCode() {
        return Objects.hash(this.nonapplicableFields);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ValidateRulesResponse other = (ValidateRulesResponse)((Object)obj);
        return this.nonapplicableFields.equals(other.nonapplicableFields);
    }
}

