/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import org.opensearch.action.ActionResponse;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.rest.RestStatus;
import org.opensearch.securityanalytics.model.Rule;

public class IndexRuleResponse
extends ActionResponse
implements ToXContentObject {
    private String id;
    private Long version;
    private RestStatus status;
    private Rule rule;

    public IndexRuleResponse(String id, Long version, RestStatus status, Rule rule) {
        this.id = id;
        this.version = version;
        this.status = status;
        this.rule = rule;
    }

    public IndexRuleResponse(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readLong(), (RestStatus)sin.readEnum(RestStatus.class), Rule.readFrom(sin));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.version.longValue());
        out.writeEnum((Enum)this.status);
        this.rule.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("_id", this.id).field("_version", this.version);
        builder.startObject("rule").field("category", this.rule.getCategory()).field("title", this.rule.getTitle()).field("log_source", this.rule.getLogSource()).field("description", this.rule.getDescription()).field("tags", this.rule.getTags()).field("references", this.rule.getReferences()).field("level", this.rule.getLevel()).field("false_positives", this.rule.getFalsePositives()).field("author", this.rule.getAuthor()).field("status", this.rule.getStatus()).field("last_update_time", (Object)this.rule.getDate()).field("rule", this.rule.getRule()).endObject();
        return builder.endObject();
    }

    public String getId() {
        return this.id;
    }
}

