/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;

public class GetMappingsViewRequest
extends ActionRequest {
    public static final String INDEX_NAME_FIELD = "index_name";
    public static final String RULE_TOPIC_FIELD = "rule_topic";
    String indexName;
    String ruleTopic;

    public GetMappingsViewRequest(String indexName, String ruleTopic) {
        this.indexName = indexName;
        this.ruleTopic = ruleTopic;
    }

    public GetMappingsViewRequest(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString());
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indexName == null || this.indexName.length() == 0) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "%s is missing", INDEX_NAME_FIELD), validationException);
        }
        if (this.ruleTopic == null || this.ruleTopic.length() == 0) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "%s is missing", RULE_TOPIC_FIELD), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeString(this.ruleTopic);
    }

    public static GetMappingsViewRequest parse(XContentParser xcp) throws IOException {
        String indexName = null;
        String ruleTopic = null;
        if (xcp.currentToken() == null) {
            xcp.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block8: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "index_name": {
                    indexName = xcp.text();
                    continue block8;
                }
                case "rule_topic": {
                    ruleTopic = xcp.text();
                    continue block8;
                }
            }
            xcp.skipChildren();
        }
        return new GetMappingsViewRequest(indexName, ruleTopic);
    }

    public GetMappingsViewRequest indexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public GetMappingsViewRequest ruleTopic(String ruleTopic) {
        this.ruleTopic = ruleTopic;
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getRuleTopic() {
        return this.ruleTopic;
    }

    public void setRuleTopic(String ruleTopic) {
        this.ruleTopic = ruleTopic;
    }
}

