/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.hotshard;

import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Record;
import org.jooq.exception.DataTypeException;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;

public class IndexShardKey {
    private static final Logger LOG = LogManager.getLogger(IndexShardKey.class);
    private final String indexName;
    private final int shardId;

    public IndexShardKey(String indexName, int shardId) {
        this.indexName = indexName;
        this.shardId = shardId;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getShardId() {
        return this.shardId;
    }

    public static IndexShardKey buildIndexShardKey(Record record) throws IllegalArgumentException {
        if (record == null) {
            throw new IllegalArgumentException("record is null");
        }
        try {
            String indexName = (String)record.getValue(AllMetrics.CommonDimension.INDEX_NAME.toString(), String.class);
            Integer shardId = (Integer)record.getValue(AllMetrics.CommonDimension.SHARD_ID.toString(), Integer.class);
            return new IndexShardKey(indexName, shardId);
        }
        catch (DataTypeException de) {
            LOG.error("Fail to read field from SQL record, message {}", (Object)de.getMessage());
            throw new IllegalArgumentException("failed to read field from record");
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof IndexShardKey) {
            IndexShardKey key = (IndexShardKey)obj;
            return this.indexName.equals(key.indexName) && this.shardId == key.shardId;
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.indexName).append(this.shardId).toHashCode();
    }

    public String toString() {
        return "[" + this.indexName + "][" + this.shardId + "]";
    }
}

