/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.decisionmaker.actions.configs.CacheActionConfig;
import org.opensearch.performanceanalyzer.decisionmaker.actions.configs.QueueActionConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.DeciderConfig;
import org.opensearch.performanceanalyzer.rca.RcaControllerHelper;
import org.opensearch.performanceanalyzer.rca.configs.AdmissionControlRcaConfig;
import org.opensearch.performanceanalyzer.rca.configs.FieldDataCacheRcaConfig;
import org.opensearch.performanceanalyzer.rca.configs.HeapSizeIncreasePolicyConfig;
import org.opensearch.performanceanalyzer.rca.configs.HighHeapUsageOldGenRcaConfig;
import org.opensearch.performanceanalyzer.rca.configs.HighHeapUsageYoungGenRcaConfig;
import org.opensearch.performanceanalyzer.rca.configs.HighOldGenOccupancyRcaConfig;
import org.opensearch.performanceanalyzer.rca.configs.HotNodeClusterRcaConfig;
import org.opensearch.performanceanalyzer.rca.configs.HotShardClusterRcaConfig;
import org.opensearch.performanceanalyzer.rca.configs.HotShardRcaConfig;
import org.opensearch.performanceanalyzer.rca.configs.OldGenContendedRcaConfig;
import org.opensearch.performanceanalyzer.rca.configs.QueueRejectionRcaConfig;
import org.opensearch.performanceanalyzer.rca.configs.ShardRequestCacheRcaConfig;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.bucket.BasicBucketCalculator;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.bucket.BucketCalculator;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.bucket.UsageBucket;
import org.opensearch.performanceanalyzer.rca.framework.core.ConfJsonWrapper;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;

public class RcaConf {
    protected String configFileLoc;
    protected long lastModifiedTime;
    protected volatile ConfJsonWrapper conf;
    protected static RcaConf instance;
    private final ObjectMapper mapper;
    private static final Logger LOG;
    private Map<String, BucketCalculator> tunableResourceToUsageBucket;

    public RcaConf(String configPath) {
        this.configFileLoc = configPath;
        this.tunableResourceToUsageBucket = new HashMap<String, BucketCalculator>();
        JsonFactory factory = new JsonFactory();
        factory.enable(JsonParser.Feature.ALLOW_COMMENTS);
        this.mapper = new ObjectMapper(factory);
        this.mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            File configFile = new File(this.configFileLoc);
            this.lastModifiedTime = configFile.lastModified();
            this.conf = (ConfJsonWrapper)this.mapper.readValue(configFile, ConfJsonWrapper.class);
        }
        catch (IOException e) {
            LOG.error("Couldn't deserialize" + e.getMessage(), (Throwable)e);
        }
    }

    @VisibleForTesting
    public RcaConf() {
        this.mapper = new ObjectMapper();
        this.tunableResourceToUsageBucket = new HashMap<String, BucketCalculator>();
    }

    @VisibleForTesting
    public void readConfigFromString(String configJson) throws JsonProcessingException {
        this.conf = (ConfJsonWrapper)this.mapper.readValue(configJson, ConfJsonWrapper.class);
    }

    public static void clear() {
        instance = null;
    }

    public String getRcaStoreLoc() {
        return this.conf.getRcaStoreLoc();
    }

    public String getThresholdStoreLoc() {
        return this.conf.getThresholdStoreLoc();
    }

    public long getNewRcaCheckPeriodicityMins() {
        return this.conf.getNewRcaCheckPeriodicityMins();
    }

    public long getNewThresholdCheckPeriodicityMins() {
        return this.conf.getNewThresholdCheckPeriodicityMins();
    }

    public List<String> getPeerIpList() {
        return this.conf.getPeerIpList();
    }

    public Map<String, String> getTagMap() {
        return this.conf.getTagMap();
    }

    public Map<String, String> getDatastore() {
        return this.conf.getDatastore();
    }

    public String getConfigFileLoc() {
        return this.configFileLoc;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String getAnalysisGraphEntryPoint() {
        return this.conf.getAnalysisGraphEntryPoint();
    }

    public int getNetworkQueueLength() {
        return this.conf.getNetworkQueueLength();
    }

    public int getPerVertexBufferLength() {
        return this.conf.getPerVertexBufferLength();
    }

    public AdmissionControlRcaConfig getAdmissionControlRcaConfig() {
        return new AdmissionControlRcaConfig(this);
    }

    public HighOldGenOccupancyRcaConfig getHighOldGenOccupancyRcaConfig() {
        return new HighOldGenOccupancyRcaConfig(this);
    }

    public HighHeapUsageOldGenRcaConfig getHighHeapUsageOldGenRcaConfig() {
        return new HighHeapUsageOldGenRcaConfig(this);
    }

    public HighHeapUsageYoungGenRcaConfig getHighHeapUsageYoungGenRcaConfig() {
        return new HighHeapUsageYoungGenRcaConfig(this);
    }

    public QueueRejectionRcaConfig getQueueRejectionRcaConfig() {
        return new QueueRejectionRcaConfig(this);
    }

    public HotNodeClusterRcaConfig getHotNodeClusterRcaConfig() {
        return new HotNodeClusterRcaConfig(this);
    }

    public HotShardRcaConfig getHotShardRcaConfig() {
        return new HotShardRcaConfig(this);
    }

    public HotShardClusterRcaConfig getHotShardClusterRcaConfig() {
        return new HotShardClusterRcaConfig(this);
    }

    public FieldDataCacheRcaConfig getFieldDataCacheRcaConfig() {
        return new FieldDataCacheRcaConfig(this);
    }

    public ShardRequestCacheRcaConfig getShardRequestCacheRcaConfig() {
        return new ShardRequestCacheRcaConfig(this);
    }

    public DeciderConfig getDeciderConfig() {
        return new DeciderConfig(this);
    }

    public List<String> getMutedRcaList() {
        return this.conf.getMutedRcaList();
    }

    public List<String> getMutedDeciderList() {
        return this.conf.getMutedDeciderList();
    }

    public List<String> getMutedActionList() {
        return this.conf.getMutedActionList();
    }

    public Map<String, Object> getRcaConfigSettings() {
        return ImmutableMap.copyOf(this.conf.getRcaConfigSettings());
    }

    public CacheActionConfig getCacheActionConfig() {
        return new CacheActionConfig(this);
    }

    public QueueActionConfig getQueueActionConfig() {
        return new QueueActionConfig(this);
    }

    public HeapSizeIncreasePolicyConfig getJvmScaleUpPolicyConfig() {
        return new HeapSizeIncreasePolicyConfig(this);
    }

    public OldGenContendedRcaConfig getOldGenContendedRcaConfig() {
        return new OldGenContendedRcaConfig(this);
    }

    public <T> T readRcaConfig(String rcaName, String key, T defaultValue, Class<? extends T> clazz) {
        return this.readRcaConfig(rcaName, key, defaultValue, s -> true, clazz);
    }

    public <T> T readRcaConfig(String rcaName, String key, T defaultValue, Predicate<T> validator, Class<? extends T> clazz) {
        T setting = defaultValue;
        try {
            Map rcaObj = null;
            if (this.conf.getRcaConfigSettings() != null && this.conf.getRcaConfigSettings().containsKey(rcaName) && this.conf.getRcaConfigSettings().get(rcaName) != null) {
                rcaObj = (Map)this.conf.getRcaConfigSettings().get(rcaName);
            }
            if (rcaObj != null && rcaObj.containsKey(key) && rcaObj.get(key) != null && !validator.test(setting = clazz.cast(rcaObj.get(key)))) {
                LOG.error("Config value: [{}] provided for key: [{}] is invalid", setting, (Object)key);
                return defaultValue;
            }
        }
        catch (ClassCastException ne) {
            LOG.error("rca.conf contains value in invalid format, trace : {}", (Object)ne.getMessage());
        }
        return setting;
    }

    public boolean updateAllRcaConfFiles(Set<String> mutedRcas, Set<String> mutedDeciders, Set<String> mutedActions) {
        boolean updateStatus = true;
        List<String> rcaConfFiles = RcaControllerHelper.getAllConfFilePaths();
        for (String confFilePath : rcaConfFiles) {
            updateStatus = this.updateRcaConf(confFilePath, mutedRcas, mutedDeciders, mutedActions);
            if (updateStatus) continue;
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat(ExceptionsAndErrors.WRITE_UPDATED_RCA_CONF_ERROR, "", 1);
            LOG.error("Failed to update the conf file at path: {}", (Object)confFilePath);
            break;
        }
        return updateStatus;
    }

    private boolean updateRcaConf(String originalFilePath, Set<String> mutedRcas, Set<String> mutedDeciders, Set<String> mutedActions) {
        String updatedPath = originalFilePath + ".updated";
        try (FileInputStream originalFileInputStream = new FileInputStream(originalFilePath);
             Scanner scanner = new Scanner((InputStream)originalFileInputStream, StandardCharsets.UTF_8.name());
             FileOutputStream updatedFileOutputStream = new FileOutputStream(updatedPath);){
            String jsonText = scanner.useDelimiter("\\A").next();
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            JsonNode configObject = mapper.readTree(jsonText);
            ArrayNode mutedRcasArray = (ArrayNode)mapper.valueToTree(mutedRcas);
            ArrayNode mutedDecidersArray = (ArrayNode)mapper.valueToTree(mutedDeciders);
            ArrayNode mutedActionsArray = (ArrayNode)mapper.valueToTree(mutedActions);
            ((ObjectNode)configObject).putArray("muted-rcas").addAll(mutedRcasArray);
            ((ObjectNode)configObject).putArray("muted-deciders").addAll(mutedDecidersArray);
            ((ObjectNode)configObject).putArray("muted-actions").addAll(mutedActionsArray);
            mapper.writeValue((OutputStream)updatedFileOutputStream, (Object)configObject);
        }
        catch (IOException e) {
            LOG.error("Unable to copy rca conf to a temp file", (Throwable)e);
            return false;
        }
        try {
            LOG.info("Writing new file: {}", (Object)Paths.get(updatedPath, new String[0]));
            Files.move(Paths.get(updatedPath, new String[0]), Paths.get(originalFilePath, new String[0]), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOG.error("Unable to move and replace the old conf file with updated conf file.", (Throwable)e);
            return false;
        }
        return true;
    }

    public Map<String, Object> getActionConfigSettings() {
        return this.conf.getActionConfigSettings();
    }

    public Map<String, Object> getDeciderConfigSettings() {
        return this.conf.getDeciderConfigSettings();
    }

    public BucketCalculator getBucketizationSettings(String tunableName) {
        BucketCalculator bucketCalculator;
        if (this.tunableResourceToUsageBucket.isEmpty()) {
            this.constructTunableResourceToUsageBucket();
        }
        if ((bucketCalculator = this.tunableResourceToUsageBucket.get(tunableName)) == null) {
            throw new IllegalArgumentException("No such tunable exists with name " + tunableName + ". Available ones: " + this.tunableResourceToUsageBucket.keySet());
        }
        return bucketCalculator;
    }

    private void constructTunableResourceToUsageBucket() {
        Map<String, Object> tunableSettingsMap = this.conf.getBucketizationTunings();
        if (tunableSettingsMap == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : tunableSettingsMap.entrySet()) {
            String currentTunable = entry.getKey();
            if (entry.getValue() instanceof Map) {
                ImmutableMap.Builder usageBucketLimitMapBuilder = ImmutableMap.builder();
                Map bucketUpperLimitPair = (Map)entry.getValue();
                for (Map.Entry bucketUpperLimitEntry : bucketUpperLimitPair.entrySet()) {
                    usageBucketLimitMapBuilder.put((Object)UsageBucket.valueOf((String)bucketUpperLimitEntry.getKey()), (Object)((Double)bucketUpperLimitEntry.getValue()));
                }
                BasicBucketCalculator calculator = new BasicBucketCalculator((Map<UsageBucket, Double>)usageBucketLimitMapBuilder.build());
                BucketCalculator old = this.tunableResourceToUsageBucket.put(currentTunable, calculator);
                if (old == null) continue;
                throw new IllegalStateException("Entry '" + currentTunable + "' exists twice." + calculator + ";" + old);
            }
            throw new IllegalStateException("Each tunable resource must be a json Object type. Not so for " + currentTunable);
        }
    }

    static {
        LOG = LogManager.getLogger(PerformanceAnalyzerApp.class);
    }
}

