/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf.impl.v7;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.security.securityconf.Hashed;
import org.opensearch.security.securityconf.Hideable;
import org.opensearch.security.securityconf.StaticDefinable;
import org.opensearch.security.securityconf.impl.v6.InternalUserV6;

public class InternalUserV7
implements Hideable,
Hashed,
StaticDefinable {
    private String hash;
    private boolean reserved;
    private boolean hidden;
    @JsonProperty(value="static")
    private boolean _static;
    private List<String> backend_roles = Collections.emptyList();
    private Map<String, String> attributes = Collections.emptyMap();
    private String description;
    private List<String> opendistro_security_roles = Collections.emptyList();

    private InternalUserV7(String hash, boolean reserved, boolean hidden, List<String> backend_roles, Map<String, String> attributes) {
        this.hash = hash;
        this.reserved = reserved;
        this.hidden = hidden;
        this.backend_roles = backend_roles;
        this.attributes = attributes;
    }

    public InternalUserV7() {
    }

    public InternalUserV7(InternalUserV6 u6) {
        this.hash = u6.getHash();
        this.reserved = u6.isReserved();
        this.hidden = u6.isHidden();
        this.backend_roles = u6.getRoles();
        this.attributes = u6.getAttributes();
        this.description = "Migrated from v6";
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public List<String> getBackend_roles() {
        return this.backend_roles;
    }

    public void setBackend_roles(List<String> backend_roles) {
        this.backend_roles = backend_roles;
    }

    public List<String> getOpendistro_security_roles() {
        return this.opendistro_security_roles;
    }

    public void setOpendistro_security_roles(List<String> opendistro_security_roles) {
        this.opendistro_security_roles = opendistro_security_roles;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        return "InternalUserV7 [hash=" + this.hash + ", reserved=" + this.reserved + ", hidden=" + this.hidden + ", _static=" + this._static + ", backend_roles=" + this.backend_roles + ", attributes=" + this.attributes + ", description=" + this.description + "]";
    }

    @Override
    @JsonIgnore
    public void clearHash() {
        this.hash = "";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isReserved() {
        return this.reserved;
    }

    public void setReserved(boolean reserved) {
        this.reserved = reserved;
    }

    @Override
    @JsonProperty(value="static")
    public boolean isStatic() {
        return this._static;
    }

    @JsonProperty(value="static")
    public void setStatic(boolean _static) {
        this._static = _static;
    }
}

