/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.load.MLLoadModelAction;
import org.opensearch.ml.common.transport.load.MLLoadModelRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLLoadModelAction
extends BaseRestHandler {
    private static final String ML_LOAD_MODEL_ACTION = "ml_load_model_action";

    public String getName() {
        return ML_LOAD_MODEL_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_load", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLLoadModelRequest mlLoadModelRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLLoadModelAction.INSTANCE, (ActionRequest)mlLoadModelRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLLoadModelRequest getRequest(RestRequest request) throws IOException {
        String modelId = request.param("model_id");
        if (!request.hasContent()) {
            return new MLLoadModelRequest(modelId, false);
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return MLLoadModelRequest.parse((XContentParser)parser, (String)modelId);
    }
}

