/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.cluster;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.LocalNodeClusterManagerListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.component.LifecycleListener;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.cluster.MLSyncUpCron;
import org.opensearch.ml.indices.MLIndicesHandler;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public class MLCommonsClusterManagerEventListener
implements LocalNodeClusterManagerListener {
    @Generated
    private static final Logger log = LogManager.getLogger(MLCommonsClusterManagerEventListener.class);
    private final ClusterService clusterService;
    private Client client;
    private ThreadPool threadPool;
    private Scheduler.Cancellable syncModelRoutingCron;
    private DiscoveryNodeHelper nodeHelper;
    private final MLIndicesHandler mlIndicesHandler;
    private volatile Integer jobInterval;

    public MLCommonsClusterManagerEventListener(ClusterService clusterService, Client client, Settings settings, ThreadPool threadPool, DiscoveryNodeHelper nodeHelper, MLIndicesHandler mlIndicesHandler) {
        this.clusterService = clusterService;
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService.addListener((ClusterStateListener)this);
        this.nodeHelper = nodeHelper;
        this.mlIndicesHandler = mlIndicesHandler;
        this.jobInterval = (Integer)MLCommonsSettings.ML_COMMONS_SYNC_UP_JOB_INTERVAL_IN_SECONDS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_SYNC_UP_JOB_INTERVAL_IN_SECONDS, it -> {
            this.jobInterval = it;
            this.cancel(this.syncModelRoutingCron);
            this.startSyncModelRoutingCron();
        });
    }

    public void onClusterManager() {
        if (this.syncModelRoutingCron == null) {
            this.startSyncModelRoutingCron();
        }
    }

    private void startSyncModelRoutingCron() {
        if (this.jobInterval > 0) {
            this.syncModelRoutingCron = this.threadPool.scheduleWithFixedDelay((Runnable)new MLSyncUpCron(this.client, this.clusterService, this.nodeHelper, this.mlIndicesHandler), TimeValue.timeValueSeconds((long)this.jobInterval.intValue()), "opensearch_ml_general");
        } else {
            log.debug("Stop ML syncup job as its interval is: {}", (Object)this.jobInterval);
        }
        this.clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                MLCommonsClusterManagerEventListener.this.cancel(MLCommonsClusterManagerEventListener.this.syncModelRoutingCron);
                MLCommonsClusterManagerEventListener.this.syncModelRoutingCron = null;
            }
        });
    }

    public void offClusterManager() {
        this.cancel(this.syncModelRoutingCron);
        this.syncModelRoutingCron = null;
    }

    private void cancel(Scheduler.Cancellable cron) {
        if (cron != null) {
            cron.cancel();
        }
    }
}

