/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.breaker;

import org.opensearch.ml.breaker.ThresholdCircuitBreaker;
import org.opensearch.monitor.jvm.JvmService;

public class MemoryCircuitBreaker
extends ThresholdCircuitBreaker<Short> {
    private static final String ML_MEMORY_CB = "Memory Circuit Breaker";
    public static final short DEFAULT_JVM_HEAP_USAGE_THRESHOLD = 85;
    private final JvmService jvmService;

    public MemoryCircuitBreaker(JvmService jvmService) {
        super((short)85);
        this.jvmService = jvmService;
    }

    public MemoryCircuitBreaker(short threshold, JvmService jvmService) {
        super(threshold);
        this.jvmService = jvmService;
    }

    @Override
    public String getName() {
        return ML_MEMORY_CB;
    }

    @Override
    public boolean isOpen() {
        return this.jvmService.stats().getMem().getHeapUsedPercent() > (Short)this.getThreshold();
    }
}

