/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.Model;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.huggingface.translator.FillMaskTranslator;
import ai.djl.modality.Classifications;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.nlp.translator.TextClassificationServingTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FillMaskTranslatorFactory
implements TranslatorFactory {
    private static final Set<Pair<Type, Type>> SUPPORTED_TYPES = new HashSet<Pair<Type, Type>>();

    public Set<Pair<Type, Type>> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) throws TranslateException {
        Path modelPath = model.getModelPath();
        try {
            HuggingFaceTokenizer tokenizer = HuggingFaceTokenizer.builder(arguments).optTokenizerPath(modelPath).optManager(model.getNDManager()).build();
            FillMaskTranslator translator = FillMaskTranslator.builder(tokenizer, arguments).build();
            if (input == String.class && output == Classifications.class) {
                return translator;
            }
            if (input == Input.class && output == Output.class) {
                return new TextClassificationServingTranslator((Translator)translator);
            }
            throw new IllegalArgumentException("Unsupported input/output types.");
        }
        catch (IOException e) {
            throw new TranslateException("Failed to load tokenizer.", (Throwable)e);
        }
    }

    static {
        SUPPORTED_TYPES.add((Pair<Type, Type>)new Pair(String.class, Classifications.class));
        SUPPORTED_TYPES.add((Pair<Type, Type>)new Pair(Input.class, Output.class));
    }
}

