/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.tokens;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.tribuo.util.tokens.Token;

public interface Tokenizer
extends Configurable,
Cloneable,
Provenancable<ConfiguredObjectProvenance> {
    public static Supplier<Tokenizer> createSupplier(Tokenizer tokenizer) {
        Supplier<Tokenizer> supplier = () -> {
            try {
                return tokenizer.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        };
        return supplier;
    }

    public static ThreadLocal<Tokenizer> createThreadLocal(Tokenizer tokenizer) {
        return ThreadLocal.withInitial(Tokenizer.createSupplier(tokenizer));
    }

    public void reset(CharSequence var1);

    public boolean advance();

    public String getText();

    public int getStart();

    public int getEnd();

    public Token.TokenType getType();

    public Tokenizer clone() throws CloneNotSupportedException;

    default public Token getToken() {
        return new Token(this.getText(), this.getStart(), this.getEnd(), this.getType());
    }

    default public List<Token> tokenize(CharSequence cs) {
        if (cs == null || cs.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.reset(cs);
        while (this.advance()) {
            tokens.add(this.getToken());
        }
        return tokens;
    }

    default public List<String> split(CharSequence cs) {
        if (cs == null || cs.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> tokens = new ArrayList<String>();
        this.reset(cs);
        while (this.advance()) {
            tokens.add(this.getText());
        }
        return tokens;
    }
}

