/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.rollup;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.indexmanagement.indexstatemanagement.action.RollupAction;
import org.opensearch.indexmanagement.indexstatemanagement.step.rollup.AttemptCreateRollupJobStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupAction;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupRequest;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupResponse;
import org.opensearch.indexmanagement.rollup.action.start.StartRollupAction;
import org.opensearch.indexmanagement.rollup.action.start.StartRollupRequest;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionProperties;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.transport.RemoteTransportException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u000f\u001a\u00020\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bJ!\u0010\u001c\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/rollup/AttemptCreateRollupJobStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "action", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/RollupAction;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/action/RollupAction;)V", "info", "", "", "", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "rollupId", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUpdatedManagedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "currentMetadata", "isIdempotent", "", "processFailure", "", "indexName", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "startRollupJob", "context", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "(Ljava/lang/String;Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "opensearch-index-management"})
public final class AttemptCreateRollupJobStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RollupAction action;
    private final Logger logger;
    @NotNull
    private Step.StepStatus stepStatus;
    @Nullable
    private Map<String, ? extends Object> info;
    @Nullable
    private String rollupId;
    @NotNull
    public static final String name = "attempt_create_rollup";

    public AttemptCreateRollupJobStep(@NotNull RollupAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        super(name, false, 2, null);
        this.action = action;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.stepStatus = Step.StepStatus.STARTING;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> var1_1) {
        block21: {
            if (!(var1_1 instanceof execute.1)) ** GOTO lbl-1000
            var12_2 = var1_1;
            if ((var12_2.label & -2147483648) != 0) {
                var12_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    /* synthetic */ Object result;
                    final /* synthetic */ AttemptCreateRollupJobStep this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = this.getContext();
                    if (v0 == null) {
                        return this;
                    }
                    context = v0;
                    indexName = context.getMetadata().getIndex();
                    managedIndexMetadata = context.getMetadata();
                    v1 = managedIndexMetadata.getActionMetaData();
                    if (v1 == null) {
                        v2 /* !! */  = null;
                    } else {
                        v3 = v1.getActionProperties();
                        v2 /* !! */  = v3 == null ? null : v3.getRollupId();
                    }
                    previousRunRollupId = v2 /* !! */ ;
                    v4 = managedIndexMetadata.getActionMetaData();
                    if (v4 == null) {
                        v5 /* !! */  = null;
                    } else {
                        v6 = v4.getActionProperties();
                        v5 /* !! */  = v6 == null ? null : v6.getHasRollupFailed();
                    }
                    hasPreviousRollupAttemptFailed = v5 /* !! */ ;
                    rollup = this.action.getIsmRollup().toRollup(indexName, context.getUser());
                    this.rollupId = rollup.getId();
                    this.logger.info("Attempting to create a rollup job " + this.rollupId + " for index " + indexName);
                    indexRollupRequest = new IndexRollupRequest(rollup, WriteRequest.RefreshPolicy.IMMEDIATE);
                    $continuation.L$0 = this;
                    $continuation.L$1 = context;
                    $continuation.L$2 = indexName;
                    $continuation.L$3 = previousRunRollupId;
                    $continuation.L$4 = hasPreviousRollupAttemptFailed;
                    $continuation.L$5 = rollup;
                    $continuation.label = 1;
                    v7 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient(), (Function2)new Function2<Client, ActionListener<IndexRollupResponse>, Unit>(indexRollupRequest){
                        final /* synthetic */ IndexRollupRequest $indexRollupRequest;
                        {
                            this.$indexRollupRequest = $indexRollupRequest;
                            super(2);
                        }

                        public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<IndexRollupResponse> it) {
                            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            $this$suspendUntil.execute((ActionType)IndexRollupAction.Companion.getINSTANCE(), (ActionRequest)this.$indexRollupRequest, it);
                        }
                    }, $continuation);
                    ** if (v7 != var13_4) goto lbl48
lbl47:
                    // 1 sources

                    return var13_4;
lbl48:
                    // 1 sources

                    ** GOTO lbl60
                }
                case 1: {
                    rollup = (Rollup)$continuation.L$5;
                    hasPreviousRollupAttemptFailed = (Boolean)$continuation.L$4;
                    previousRunRollupId = (String)$continuation.L$3;
                    indexName = (String)$continuation.L$2;
                    context = (StepContext)$continuation.L$1;
                    this = (AttemptCreateRollupJobStep)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl60:
                        // 2 sources

                        response = (IndexRollupResponse)v7;
                        this.logger.info("Received status " + response.getStatus().getStatus() + " on trying to create rollup job " + this.rollupId);
                        this.stepStatus = Step.StepStatus.COMPLETED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptCreateRollupJobStep.Companion.getSuccessMessage(rollup.getId(), indexName)));
                    }
                    catch (VersionConflictEngineException response) {
                        message = AttemptCreateRollupJobStep.Companion.getFailedJobExistsMessage(rollup.getId(), indexName);
                        this.logger.info(message);
                        if (!Intrinsics.areEqual((Object)this.rollupId, (Object)previousRunRollupId) || !Intrinsics.areEqual((Object)hasPreviousRollupAttemptFailed, (Object)Boxing.boxBoolean((boolean)true))) break;
                        $continuation.L$0 = this;
                        $continuation.L$1 = null;
                        $continuation.L$2 = null;
                        $continuation.L$3 = null;
                        $continuation.L$4 = null;
                        $continuation.L$5 = null;
                        $continuation.label = 2;
                        v8 = this.startRollupJob(rollup.getId(), context, (Continuation<? super Unit>)$continuation);
                        if (v8 == var13_4) {
                            return var13_4;
                        }
                        break block21;
                    }
                }
                case 2: {
                    this = (AttemptCreateRollupJobStep)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v8 = $result;
                    break block21;
                }
            }
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"info", (Object)message));
            break block21;
            catch (RemoteTransportException e) {
                v9 = ExceptionsHelper.unwrapCause((Throwable)e);
                if (v9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                }
                this.processFailure(rollup.getId(), indexName, (Exception)v9);
                break block21;
            }
            catch (OpenSearchException e) {
                this.processFailure(rollup.getId(), indexName, (Exception)e);
                break block21;
            }
            catch (Exception e) {
                this.processFailure(rollup.getId(), indexName, e);
            }
        }
        return this;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void processFailure(@NotNull String rollupId, @NotNull String indexName, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)rollupId, (String)"rollupId");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String message = Companion.getFailedMessage(rollupId, indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message), TuplesKt.to((Object)"cause", (Object)String.valueOf(e.getMessage()))};
        this.info = MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * Unable to fully structure code
     */
    private final Object startRollupJob(String var1_1, StepContext var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof startRollupJob.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptCreateRollupJobStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AttemptCreateRollupJobStep.access$startRollupJob(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                indexName = context.getMetadata().getIndex();
                client = context.getClient();
                this.logger.info("Attempting to re-start the job " + rollupId);
                startRollupRequest = new StartRollupRequest(rollupId);
                $continuation.L$0 = this;
                $continuation.L$1 = rollupId;
                $continuation.L$2 = indexName;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client, (Function2)new Function2<Client, ActionListener<AcknowledgedResponse>, Unit>(startRollupRequest){
                    final /* synthetic */ StartRollupRequest $startRollupRequest;
                    {
                        this.$startRollupRequest = $startRollupRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.execute((ActionType)StartRollupAction.Companion.getINSTANCE(), (ActionRequest)this.$startRollupRequest, it);
                    }
                }, $continuation);
                ** if (v0 != var10_6) goto lbl25
lbl24:
                // 1 sources

                return var10_6;
lbl25:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                indexName = (String)$continuation.L$2;
                rollupId = (String)$continuation.L$1;
                this = (AttemptCreateRollupJobStep)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl34:
                    // 2 sources

                    this.stepStatus = Step.StepStatus.COMPLETED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptCreateRollupJobStep.Companion.getSuccessRestartMessage(rollupId, indexName)));
                }
                catch (Exception e) {
                    message = AttemptCreateRollupJobStep.Companion.getFailedToStartMessage(rollupId, indexName);
                    this.logger.error(message, (Throwable)e);
                    this.stepStatus = Step.StepStatus.FAILED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        ActionMetaData currentActionMetaData;
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        ActionMetaData actionMetaData = currentActionMetaData = currentMetadata.getActionMetaData();
        ActionMetaData actionMetaData2 = actionMetaData == null ? null : ActionMetaData.copy$default((ActionMetaData)actionMetaData, null, null, (int)0, (boolean)false, (int)0, null, (ActionProperties)new ActionProperties(null, null, this.rollupId, null, null, 27, null), (int)63, null);
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, (ActionMetaData)actionMetaData2, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, (int)119551, null);
    }

    public boolean isIdempotent() {
        return true;
    }

    public static final /* synthetic */ Object access$startRollupJob(AttemptCreateRollupJobStep $this, String rollupId, StepContext context, Continuation $completion) {
        return $this.startRollupJob(rollupId, context, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/rollup/AttemptCreateRollupJobStep$Companion;", "", "()V", "name", "", "getFailedJobExistsMessage", "rollupId", "index", "getFailedMessage", "getFailedToStartMessage", "getSuccessMessage", "getSuccessRestartMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedMessage(@NotNull String rollupId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupId, (String)"rollupId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to create the rollup job [" + rollupId + "] [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedJobExistsMessage(@NotNull String rollupId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupId, (String)"rollupId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Rollup job [" + rollupId + "] already exists, skipping creation [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedToStartMessage(@NotNull String rollupId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupId, (String)"rollupId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to start the rollup job [" + rollupId + "] [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String rollupId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupId, (String)"rollupId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully created the rollup job [" + rollupId + "] [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessRestartMessage(@NotNull String rollupId, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupId, (String)"rollupId");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully restarted the rollup job [" + rollupId + "] [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

