/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.common.Strings;
import org.opensearch.common.ValidationException;
import org.opensearch.common.regex.Regex;
import org.opensearch.indexmanagement.indexstatemanagement.model.ISMTemplate;
import org.opensearch.indexmanagement.util.IndexManagementException;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001aL\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\n*\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\n2\u0006\u0010\f\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\r\u001a\u00020\u000e\u001a*\u0010\u000f\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0018\u00010\u0010*\b\u0012\u0004\u0012\u00020\u000b0\u0003\u00a8\u0006\u0011"}, d2={"overlapping", "", "p1", "", "", "p2", "validateFormat", "Lorg/opensearch/OpenSearchException;", "indexPatterns", "findConflictingPolicyTemplates", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ISMTemplate;", "candidate", "priority", "", "findSelfConflictingTemplates", "Lkotlin/Pair;", "opensearch-index-management"})
public final class ISMTemplateServiceKt {
    @Nullable
    public static final OpenSearchException validateFormat(@NotNull List<String> indexPatterns) {
        Intrinsics.checkNotNullParameter(indexPatterns, (String)"indexPatterns");
        List indexPatternFormatErrors = new ArrayList();
        for (String indexPattern : indexPatterns) {
            if (StringsKt.contains$default((CharSequence)indexPattern, (CharSequence)"#", (boolean)false, (int)2, null)) {
                indexPatternFormatErrors.add("index_pattern [" + indexPattern + "] must not contain a '#'");
            }
            if (StringsKt.contains$default((CharSequence)indexPattern, (CharSequence)":", (boolean)false, (int)2, null)) {
                indexPatternFormatErrors.add("index_pattern [" + indexPattern + "] must not contain a ':'");
            }
            if (StringsKt.startsWith$default((String)indexPattern, (String)"_", (boolean)false, (int)2, null)) {
                indexPatternFormatErrors.add("index_pattern [" + indexPattern + "] must not start with '_'");
            }
            if (Strings.validFileNameExcludingAstrix((String)indexPattern)) continue;
            indexPatternFormatErrors.add("index_pattern [" + indexPattern + "] must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (indexPatternFormatErrors.size() > 0) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors((Iterable)indexPatternFormatErrors);
            return IndexManagementException.Companion.wrap((Exception)validationException);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Pair<List<String>, List<String>> findSelfConflictingTemplates(@NotNull List<ISMTemplate> $this$findSelfConflictingTemplates) {
        List templateList;
        Object element$iv;
        Intrinsics.checkNotNullParameter($this$findSelfConflictingTemplates, (String)"<this>");
        Map priorityToTemplates = new LinkedHashMap();
        Object $this$forEach$iv = $this$findSelfConflictingTemplates;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            ISMTemplate it = (ISMTemplate)element$iv;
            boolean bl = false;
            templateList = (List)priorityToTemplates.get(it.getPriority());
            if (templateList != null) {
                priorityToTemplates.put(it.getPriority(), CollectionsKt.plus((Collection)templateList, (Object)it));
                continue;
            }
            Object[] objectArray = new ISMTemplate[]{it};
            priorityToTemplates.put(it.getPriority(), CollectionsKt.mutableListOf((Object[])objectArray));
        }
        $this$forEach$iv = priorityToTemplates;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Object $dstr$_u24__u24$templateList = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            templateList = (List)$dstr$_u24__u24$templateList.getValue();
            Iterable $this$map$iv = templateList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ISMTemplate iSMTemplate = (ISMTemplate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getIndexPatterns());
            }
            List indexPatternsList = (List)destination$iv$iv;
            if (indexPatternsList.size() <= 1) continue;
            Iterable $this$forEachIndexed$iv = indexPatternsList;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void indexPatterns;
                Object item$iv$iv;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv$iv = (List)item$iv;
                int ind = n;
                boolean bl3 = false;
                List comparePatterns = CollectionsKt.flatten((Iterable)indexPatternsList.subList(ind + 1, indexPatternsList.size()));
                if (!ISMTemplateServiceKt.overlapping((List<String>)indexPatterns, comparePatterns)) continue;
                return TuplesKt.to((Object)indexPatterns, (Object)comparePatterns);
            }
        }
        return null;
    }

    public static final boolean overlapping(@NotNull List<String> p1, @NotNull List<String> p2) {
        Intrinsics.checkNotNullParameter(p1, (String)"p1");
        Intrinsics.checkNotNullParameter(p2, (String)"p2");
        if (p1.isEmpty() || p2.isEmpty()) {
            return false;
        }
        Collection $this$toTypedArray$iv = p1;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] stringArray2 = stringArray;
        Automaton a1 = Regex.simpleMatchToAutomaton((String[])Arrays.copyOf(stringArray2, stringArray2.length));
        Collection $this$toTypedArray$iv2 = p2;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        String[] stringArray3 = thisCollection$iv2.toArray(new String[0]);
        if (stringArray3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] stringArray4 = stringArray3;
        Automaton a2 = Regex.simpleMatchToAutomaton((String[])Arrays.copyOf(stringArray4, stringArray4.length));
        return !Operations.isEmpty((Automaton)Operations.intersection((Automaton)a1, (Automaton)a2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<String>> findConflictingPolicyTemplates(@NotNull Map<String, ? extends List<ISMTemplate>> $this$findConflictingPolicyTemplates, @NotNull String candidate, @NotNull List<String> indexPatterns, int priority) {
        Intrinsics.checkNotNullParameter($this$findConflictingPolicyTemplates, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        Intrinsics.checkNotNullParameter(indexPatterns, (String)"indexPatterns");
        Map overlappingTemplates = new LinkedHashMap();
        Map<String, ? extends List<ISMTemplate>> $this$forEach$iv = $this$findConflictingPolicyTemplates;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends List<ISMTemplate>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            ISMTemplate it;
            void $this$filterTo$iv$iv;
            Map.Entry<String, ? extends List<ISMTemplate>> element$iv;
            Map.Entry<String, ? extends List<ISMTemplate>> $dstr$policyID$templateList = element$iv = iterator.next();
            boolean bl = false;
            String policyID = $dstr$policyID$templateList.getKey();
            List<ISMTemplate> templateList = $dstr$policyID$templateList.getValue();
            Iterable $this$filter$iv = templateList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ISMTemplate)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getPriority() == priority)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ISMTemplate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getIndexPatterns());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                List it2 = (List)element$iv2;
                boolean bl4 = false;
                if (!ISMTemplateServiceKt.overlapping(indexPatterns, it2)) continue;
                overlappingTemplates.put(policyID, it2);
            }
        }
        overlappingTemplates.remove(candidate);
        return overlappingTemplates;
    }
}

