/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.spi.indexstatemanagement;

import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionRetry;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionTimeout;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.PolicyRetryInfoMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StateMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 82\u00020\u00012\u00020\u0002:\u00018B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H&J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020 0$H&J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0004J\u000e\u0010*\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(J\u000e\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0004J\u000e\u0010-\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0004J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0018\u0010.\u001a\u00020/2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0016\u00106\u001a\u0002032\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\u000e\u00107\u001a\u00020/2\u0006\u00100\u001a\u000201R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00069"}, d2={"Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Action;", "Lorg/opensearch/common/xcontent/ToXContentObject;", "Lorg/opensearch/common/io/stream/Writeable;", "type", "", "actionIndex", "", "(Ljava/lang/String;I)V", "getActionIndex", "()I", "configRetry", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry;", "getConfigRetry", "()Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry;", "setConfigRetry", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry;)V", "configTimeout", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionTimeout;", "getConfigTimeout", "()Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionTimeout;", "setConfigTimeout", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionTimeout;)V", "customAction", "", "getCustomAction", "()Z", "setCustomAction", "(Z)V", "getType", "()Ljava/lang/String;", "deleteIndexMetadataAfterFinish", "getStepToExecute", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "context", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "getSteps", "", "getUpdatedActionMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionMetaData;", "managedIndexMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "stateName", "isFinishedSuccessfully", "isFirstStep", "stepName", "isLastStep", "populateAction", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "builder", "Lorg/opensearch/common/xcontent/XContentBuilder;", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "toXContent", "writeTo", "Companion", "opensearch-index-management-spi"})
public abstract class Action
implements ToXContentObject,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    private final int actionIndex;
    @Nullable
    private ActionTimeout configTimeout;
    @Nullable
    private ActionRetry configRetry;
    private boolean customAction;
    public static final long DEFAULT_RETRIES = 3L;
    @NotNull
    public static final String CUSTOM_ACTION_FIELD = "custom";
    @NotNull
    public static final String EXCLUDE_CUSTOM_FIELD_PARAM = "exclude_custom";

    public Action(@NotNull String type, int actionIndex) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = type;
        this.actionIndex = actionIndex;
        this.configRetry = new ActionRetry(3L, null, null, 6, null);
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final int getActionIndex() {
        return this.actionIndex;
    }

    @Nullable
    public final ActionTimeout getConfigTimeout() {
        return this.configTimeout;
    }

    public final void setConfigTimeout(@Nullable ActionTimeout actionTimeout) {
        this.configTimeout = actionTimeout;
    }

    @Nullable
    public final ActionRetry getConfigRetry() {
        return this.configRetry;
    }

    public final void setConfigRetry(@Nullable ActionRetry actionRetry) {
        this.configRetry = actionRetry;
    }

    public final boolean getCustomAction() {
        return this.customAction;
    }

    public final void setCustomAction(boolean bl) {
        this.customAction = bl;
    }

    @NotNull
    public final XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        ActionTimeout actionTimeout = this.configTimeout;
        if (actionTimeout != null) {
            actionTimeout.toXContent(builder, params);
        }
        ActionRetry actionRetry = this.configRetry;
        if (actionRetry != null) {
            actionRetry.toXContent(builder, params);
        }
        if (this.customAction && !params.paramAsBoolean(EXCLUDE_CUSTOM_FIELD_PARAM, false)) {
            builder.startObject(CUSTOM_ACTION_FIELD);
        }
        this.populateAction(builder, params);
        if (this.customAction && !params.paramAsBoolean(EXCLUDE_CUSTOM_FIELD_PARAM, false)) {
            builder.endObject();
        }
        XContentBuilder xContentBuilder = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.endObject()");
        return xContentBuilder;
    }

    public void populateAction(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject(this.type).endObject();
    }

    public final void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.type);
        out.writeOptionalWriteable((Writeable)this.configTimeout);
        out.writeOptionalWriteable((Writeable)this.configRetry);
        this.populateAction(out);
    }

    @NotNull
    public final ActionMetaData getUpdatedActionMetadata(@NotNull ManagedIndexMetaData managedIndexMetaData, @NotNull String stateName) {
        ActionMetaData actionMetaData;
        Intrinsics.checkNotNullParameter((Object)managedIndexMetaData, (String)"managedIndexMetaData");
        Intrinsics.checkNotNullParameter((Object)stateName, (String)"stateName");
        StateMetaData stateMetaData = managedIndexMetaData.getStateMetaData();
        ActionMetaData actionMetaData2 = managedIndexMetaData.getActionMetaData();
        StateMetaData stateMetaData2 = stateMetaData;
        if (!Intrinsics.areEqual((Object)(stateMetaData2 == null ? null : stateMetaData2.getName()), (Object)stateName)) {
            actionMetaData = new ActionMetaData(this.type, Instant.now().toEpochMilli(), this.actionIndex, false, 0, 0L, null);
        } else {
            ActionMetaData actionMetaData3 = actionMetaData2;
            if (!(actionMetaData3 == null ? false : actionMetaData3.getIndex() == this.actionIndex)) {
                actionMetaData = new ActionMetaData(this.type, Instant.now().toEpochMilli(), this.actionIndex, false, 0, 0L, null);
            } else {
                Long l = actionMetaData2.getStartTime();
                actionMetaData = ActionMetaData.copy$default(actionMetaData2, null, l == null ? Instant.now().toEpochMilli() : l.longValue(), 0, false, 0, null, null, 125, null);
            }
        }
        return actionMetaData;
    }

    public void populateAction(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(this.actionIndex);
    }

    @NotNull
    public abstract List<Step> getSteps();

    @NotNull
    public abstract Step getStepToExecute(@NotNull StepContext var1);

    public final boolean isLastStep(@NotNull String stepName) {
        Intrinsics.checkNotNullParameter((Object)stepName, (String)"stepName");
        return Intrinsics.areEqual((Object)((Step)CollectionsKt.last(this.getSteps())).getName(), (Object)stepName);
    }

    public final boolean isFirstStep(@NotNull String stepName) {
        Intrinsics.checkNotNullParameter((Object)stepName, (String)"stepName");
        return Intrinsics.areEqual((Object)((Step)CollectionsKt.first(this.getSteps())).getName(), (Object)stepName);
    }

    public final boolean isFinishedSuccessfully(@NotNull ManagedIndexMetaData managedIndexMetaData) {
        PolicyRetryInfoMetaData policyRetryInfo;
        Intrinsics.checkNotNullParameter((Object)managedIndexMetaData, (String)"managedIndexMetaData");
        PolicyRetryInfoMetaData policyRetryInfoMetaData = policyRetryInfo = managedIndexMetaData.getPolicyRetryInfo();
        if (policyRetryInfoMetaData == null ? false : policyRetryInfoMetaData.getFailed()) {
            return false;
        }
        ActionMetaData actionMetaData = managedIndexMetaData.getActionMetaData();
        if (actionMetaData == null || actionMetaData.getFailed() || !Intrinsics.areEqual((Object)actionMetaData.getName(), (Object)this.type)) {
            return false;
        }
        StepMetaData stepMetaData = managedIndexMetaData.getStepMetaData();
        return stepMetaData != null && this.isLastStep(stepMetaData.getName()) && stepMetaData.getStepStatus() == Step.StepStatus.COMPLETED;
    }

    public boolean deleteIndexMetadataAfterFinish() {
        return false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Action$Companion;", "", "()V", "CUSTOM_ACTION_FIELD", "", "DEFAULT_RETRIES", "", "EXCLUDE_CUSTOM_FIELD_PARAM", "opensearch-index-management-spi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

