/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.tasks.CancellableTask;
import org.opensearch.tasks.TaskManager;

public class TaskCancellation
implements Comparable<TaskCancellation> {
    private final CancellableTask task;
    private final List<Reason> reasons;
    private final List<Runnable> onCancelCallbacks;

    public TaskCancellation(CancellableTask task, List<Reason> reasons, List<Runnable> onCancelCallbacks) {
        this.task = task;
        this.reasons = reasons;
        this.onCancelCallbacks = onCancelCallbacks;
    }

    public CancellableTask getTask() {
        return this.task;
    }

    public List<Reason> getReasons() {
        return this.reasons;
    }

    public String getReasonString() {
        return this.reasons.stream().map(Reason::getMessage).collect(Collectors.joining(", "));
    }

    public void cancel() {
        if (!this.isEligibleForCancellation()) {
            return;
        }
        this.task.cancel(this.getReasonString());
        this.runOnCancelCallbacks();
    }

    public void cancelTaskAndDescendants(TaskManager taskManager) {
        if (!this.isEligibleForCancellation()) {
            return;
        }
        taskManager.cancelTaskAndDescendants(this.task, this.getReasonString(), false, ActionListener.wrap(() -> {}));
        this.runOnCancelCallbacks();
    }

    private void runOnCancelCallbacks() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Runnable callback : this.onCancelCallbacks) {
            try {
                callback.run();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
    }

    public int totalCancellationScore() {
        return this.reasons.stream().mapToInt(Reason::getCancellationScore).sum();
    }

    public boolean isEligibleForCancellation() {
        return !this.task.isCancelled() && this.reasons.size() > 0;
    }

    @Override
    public int compareTo(TaskCancellation other) {
        return Integer.compare(this.totalCancellationScore(), other.totalCancellationScore());
    }

    public static class Reason {
        private final String message;
        private final int cancellationScore;

        public Reason(String message, int cancellationScore) {
            this.message = message;
            this.cancellationScore = cancellationScore;
        }

        public String getMessage() {
            return this.message;
        }

        public int getCancellationScore() {
            return this.cancellationScore;
        }
    }
}

