/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.index.engine.EngineException;
import org.opensearch.index.engine.InternalEngine;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.RemoteSegmentStoreDirectory;

public final class RemoteStoreRefreshListener
implements ReferenceManager.RefreshListener {
    static final Set<String> EXCLUDE_FILES = Set.of("write.lock");
    static final int LAST_N_METADATA_FILES_TO_KEEP = 10;
    static final String SEGMENT_INFO_SNAPSHOT_FILENAME_PREFIX = "segment_infos_snapshot_filename";
    private final IndexShard indexShard;
    private final Directory storeDirectory;
    private final RemoteSegmentStoreDirectory remoteDirectory;
    private final Map<String, String> localSegmentChecksumMap;
    private long primaryTerm;
    private static final Logger logger = LogManager.getLogger(RemoteStoreRefreshListener.class);

    public RemoteStoreRefreshListener(IndexShard indexShard) {
        this.indexShard = indexShard;
        this.storeDirectory = indexShard.store().directory();
        this.remoteDirectory = (RemoteSegmentStoreDirectory)((FilterDirectory)((FilterDirectory)indexShard.remoteStore().directory()).getDelegate()).getDelegate();
        this.primaryTerm = indexShard.getOperationPrimaryTerm();
        this.localSegmentChecksumMap = new HashMap<String, String>();
        if (indexShard.shardRouting.primary()) {
            try {
                this.remoteDirectory.init();
            }
            catch (IOException e) {
                logger.error("Exception while initialising RemoteSegmentStoreDirectory", (Throwable)e);
            }
        }
    }

    public void beforeRefresh() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterRefresh(boolean didRefresh) {
        RemoteStoreRefreshListener remoteStoreRefreshListener = this;
        synchronized (remoteStoreRefreshListener) {
            block29: {
                try {
                    if (!this.indexShard.getReplicationTracker().isPrimaryMode()) break block29;
                    if (this.primaryTerm != this.indexShard.getOperationPrimaryTerm()) {
                        this.primaryTerm = this.indexShard.getOperationPrimaryTerm();
                        this.remoteDirectory.init();
                    }
                    try {
                        if (this.isRefreshAfterCommit()) {
                            this.deleteStaleCommits();
                        }
                        String segmentInfoSnapshotFilename = null;
                        try (GatedCloseable<SegmentInfos> segmentInfosGatedCloseable = this.indexShard.getSegmentInfosSnapshot();){
                            SegmentInfos segmentInfos = segmentInfosGatedCloseable.get();
                            Collection localSegmentsPostRefresh = segmentInfos.files(true);
                            List segmentInfosFiles = localSegmentsPostRefresh.stream().filter(file -> file.startsWith("segments")).collect(Collectors.toList());
                            Optional<String> latestSegmentInfos = segmentInfosFiles.stream().max(Comparator.comparingLong(SegmentInfos::generationFromSegmentsFileName));
                            if (latestSegmentInfos.isPresent()) {
                                localSegmentsPostRefresh.addAll(SegmentInfos.readCommit((Directory)this.storeDirectory, (String)latestSegmentInfos.get()).files(true));
                                segmentInfosFiles.stream().filter(file -> !file.equals(latestSegmentInfos.get())).forEach(localSegmentsPostRefresh::remove);
                                boolean uploadStatus = this.uploadNewSegments(localSegmentsPostRefresh);
                                if (uploadStatus) {
                                    segmentInfoSnapshotFilename = this.uploadSegmentInfosSnapshot(latestSegmentInfos.get(), segmentInfos);
                                    localSegmentsPostRefresh.add(segmentInfoSnapshotFilename);
                                    this.remoteDirectory.uploadMetadata(localSegmentsPostRefresh, this.storeDirectory, this.indexShard.getOperationPrimaryTerm(), segmentInfos.getGeneration());
                                    this.localSegmentChecksumMap.keySet().stream().filter(file -> !localSegmentsPostRefresh.contains(file)).collect(Collectors.toSet()).forEach(this.localSegmentChecksumMap::remove);
                                    long lastRefreshedCheckpoint = ((InternalEngine)this.indexShard.getEngine()).lastRefreshedCheckpoint();
                                    ((InternalEngine)this.indexShard.getEngine()).translogManager().setMinSeqNoToKeep(lastRefreshedCheckpoint + 1L);
                                }
                            }
                        }
                        catch (EngineException e) {
                            logger.warn("Exception while reading SegmentInfosSnapshot", (Throwable)e);
                        }
                        finally {
                            try {
                                if (segmentInfoSnapshotFilename != null) {
                                    this.storeDirectory.deleteFile(segmentInfoSnapshotFilename);
                                }
                            }
                            catch (IOException e) {
                                logger.warn("Exception while deleting: " + segmentInfoSnapshotFilename, (Throwable)e);
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.warn("Exception while uploading new segments to the remote segment store", (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    logger.error("Exception in RemoteStoreRefreshListener.afterRefresh()", t);
                }
            }
        }
    }

    private boolean isRefreshAfterCommit() throws IOException {
        String lastCommittedLocalSegmentFileName = SegmentInfos.getLastCommitSegmentsFileName((Directory)this.storeDirectory);
        return lastCommittedLocalSegmentFileName != null && !this.remoteDirectory.containsFile(lastCommittedLocalSegmentFileName, this.getChecksumOfLocalFile(lastCommittedLocalSegmentFileName));
    }

    String uploadSegmentInfosSnapshot(String latestSegmentsNFilename, SegmentInfos segmentInfosSnapshot) throws IOException {
        long maxSeqNoFromSegmentInfos = this.indexShard.getEngine().getMaxSeqNoFromSegmentInfos(segmentInfosSnapshot);
        Map userData = segmentInfosSnapshot.getUserData();
        userData.put("local_checkpoint", String.valueOf(maxSeqNoFromSegmentInfos));
        userData.put("max_seq_no", Long.toString(maxSeqNoFromSegmentInfos));
        segmentInfosSnapshot.setUserData(userData, false);
        long commitGeneration = SegmentInfos.generationFromSegmentsFileName((String)latestSegmentsNFilename);
        String segmentInfoSnapshotFilename = "segment_infos_snapshot_filename__" + commitGeneration;
        try (IndexOutput indexOutput = this.storeDirectory.createOutput(segmentInfoSnapshotFilename, IOContext.DEFAULT);){
            segmentInfosSnapshot.write(indexOutput);
        }
        this.storeDirectory.sync(Collections.singleton(segmentInfoSnapshotFilename));
        this.remoteDirectory.copyFrom(this.storeDirectory, segmentInfoSnapshotFilename, segmentInfoSnapshotFilename, IOContext.DEFAULT, true);
        return segmentInfoSnapshotFilename;
    }

    boolean uploadNewSegments(Collection<String> localFiles) throws IOException {
        AtomicBoolean uploadSuccess = new AtomicBoolean(true);
        localFiles.stream().filter(file -> !EXCLUDE_FILES.contains(file)).filter(file -> {
            try {
                return !this.remoteDirectory.containsFile((String)file, this.getChecksumOfLocalFile((String)file));
            }
            catch (IOException e) {
                logger.info("Exception while reading checksum of local segment file: {}, ignoring the exception and re-uploading the file", file);
                return true;
            }
        }).forEach(file -> {
            try {
                this.remoteDirectory.copyFrom(this.storeDirectory, (String)file, (String)file, IOContext.DEFAULT);
            }
            catch (IOException e) {
                uploadSuccess.set(false);
                logger.warn(() -> new ParameterizedMessage("Exception while uploading file {} to the remote segment store", file), (Throwable)e);
            }
        });
        return uploadSuccess.get();
    }

    private String getChecksumOfLocalFile(String file) throws IOException {
        if (!this.localSegmentChecksumMap.containsKey(file)) {
            try (IndexInput indexInput = this.storeDirectory.openInput(file, IOContext.DEFAULT);){
                String checksum = Long.toString(CodecUtil.retrieveChecksum((IndexInput)indexInput));
                this.localSegmentChecksumMap.put(file, checksum);
            }
        }
        return this.localSegmentChecksumMap.get(file);
    }

    private void deleteStaleCommits() {
        try {
            this.remoteDirectory.deleteStaleSegments(10);
        }
        catch (IOException e) {
            logger.info("Exception while deleting stale commits from remote segment store, will retry delete post next commit", (Throwable)e);
        }
    }
}

