/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.rest;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.extensions.DiscoveryExtensionNode;
import org.opensearch.extensions.rest.ExtensionRestRequest;
import org.opensearch.extensions.rest.RegisterRestActionsRequest;
import org.opensearch.extensions.rest.RestExecuteOnExtensionResponse;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestStatus;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class RestSendToExtensionAction
extends BaseRestHandler {
    private static final String SEND_TO_EXTENSION_ACTION = "send_to_extension_action";
    private static final Logger logger = LogManager.getLogger(RestSendToExtensionAction.class);
    private static final Principal DEFAULT_PRINCIPAL = new Principal(){

        @Override
        public String getName() {
            return "OpenSearchUser";
        }
    };
    private final List<RestHandler.Route> routes;
    private final String pathPrefix;
    private final DiscoveryExtensionNode discoveryExtensionNode;
    private final TransportService transportService;

    public RestSendToExtensionAction(RegisterRestActionsRequest restActionsRequest, DiscoveryExtensionNode discoveryExtensionNode, TransportService transportService) {
        this.pathPrefix = "/_extensions/_" + restActionsRequest.getUniqueId();
        ArrayList<RestHandler.Route> restActionsAsRoutes = new ArrayList<RestHandler.Route>();
        for (String restAction : restActionsRequest.getRestActions()) {
            String path;
            RestRequest.Method method;
            try {
                int delim = restAction.indexOf(32);
                method = RestRequest.Method.valueOf(restAction.substring(0, delim));
                path = this.pathPrefix + restAction.substring(delim).trim();
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                throw new IllegalArgumentException(restAction + " does not begin with a valid REST method");
            }
            logger.info("Registering: " + method + " " + path);
            restActionsAsRoutes.add(new RestHandler.Route(method, path));
        }
        this.routes = Collections.unmodifiableList(restActionsAsRoutes);
        this.discoveryExtensionNode = discoveryExtensionNode;
        this.transportService = transportService;
    }

    @Override
    public String getName() {
        return SEND_TO_EXTENSION_ACTION;
    }

    @Override
    public List<RestHandler.Route> routes() {
        return this.routes;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        RestRequest.Method method = request.method();
        String path = request.path();
        Map<String, String> params = request.params();
        XContentType contentType = request.getXContentType();
        BytesReference content = request.content();
        if (path.startsWith(this.pathPrefix)) {
            path = path.substring(this.pathPrefix.length());
        }
        String message = "Forwarding the request " + method + " " + path + " to " + this.discoveryExtensionNode;
        logger.info(message);
        final RestExecuteOnExtensionResponse restExecuteOnExtensionResponse = new RestExecuteOnExtensionResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", message.getBytes(StandardCharsets.UTF_8), Collections.emptyMap(), Collections.emptyList(), false);
        final CompletableFuture inProgressFuture = new CompletableFuture();
        TransportResponseHandler<RestExecuteOnExtensionResponse> restExecuteOnExtensionResponseHandler = new TransportResponseHandler<RestExecuteOnExtensionResponse>(){

            @Override
            public RestExecuteOnExtensionResponse read(StreamInput in) throws IOException {
                return new RestExecuteOnExtensionResponse(in);
            }

            @Override
            public void handleResponse(RestExecuteOnExtensionResponse response) {
                logger.info("Received response from extension: {}", (Object)response.getStatus());
                restExecuteOnExtensionResponse.setStatus(response.getStatus());
                restExecuteOnExtensionResponse.setContentType(response.getContentType());
                restExecuteOnExtensionResponse.setContent(response.getContent());
                restExecuteOnExtensionResponse.setHeaders(response.getHeaders());
                response.getConsumedParams().stream().forEach(p -> request.param((String)p));
                if (response.isContentConsumed()) {
                    request.content();
                }
                inProgressFuture.complete(response);
            }

            @Override
            public void handleException(TransportException exp) {
                logger.debug("REST request failed", (Throwable)exp);
                inProgressFuture.completeExceptionally(exp);
            }

            @Override
            public String executor() {
                return "generic";
            }
        };
        try {
            String extensionTokenProcessor = "placeholder_token_processor";
            String requestIssuerIdentity = "placeholder_request_issuer_identity";
            this.transportService.sendRequest(this.discoveryExtensionNode, "internal:extensions/restexecuteonextensiontaction", new ExtensionRestRequest(method, path, params, contentType, content, "placeholder_request_issuer_identity"), restExecuteOnExtensionResponseHandler);
            inProgressFuture.orTimeout(10L, TimeUnit.SECONDS).join();
        }
        catch (CompletionException e2) {
            Throwable cause = e2.getCause();
            if (cause instanceof TimeoutException) {
                return channel -> channel.sendResponse(new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, "No response from extension to request."));
            }
            if (e2.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e2.getCause();
            }
            if (e2.getCause() instanceof Error) {
                throw (Error)e2.getCause();
            }
            throw new RuntimeException(e2.getCause());
        }
        catch (Exception ex) {
            logger.info("Failed to send REST Actions to extension " + this.discoveryExtensionNode.getName(), (Throwable)ex);
            return channel -> channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, ex.getMessage()));
        }
        BytesRestResponse restResponse = new BytesRestResponse(restExecuteOnExtensionResponse.getStatus(), restExecuteOnExtensionResponse.getContentType(), restExecuteOnExtensionResponse.getContent());
        restExecuteOnExtensionResponse.getHeaders().entrySet().stream().forEach(e -> ((List)e.getValue()).stream().forEach(v -> restResponse.addHeader((String)e.getKey(), (String)v)));
        return channel -> channel.sendResponse(restResponse);
    }
}

