/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.action;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.extensions.AcknowledgedResponse;
import org.opensearch.extensions.DiscoveryExtensionNode;
import org.opensearch.extensions.RegisterTransportActionsRequest;
import org.opensearch.extensions.action.ExtensionActionRequest;
import org.opensearch.extensions.action.ExtensionActionResponse;
import org.opensearch.extensions.action.ExtensionHandleTransportRequest;
import org.opensearch.extensions.action.ExtensionProxyAction;
import org.opensearch.extensions.action.TransportActionRequestFromExtension;
import org.opensearch.extensions.action.TransportActionResponseToExtension;
import org.opensearch.transport.ActionNotFoundTransportException;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportResponse;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class ExtensionTransportActionsHandler {
    private static final Logger logger = LogManager.getLogger(ExtensionTransportActionsHandler.class);
    private Map<String, DiscoveryExtensionNode> actionsMap = new HashMap<String, DiscoveryExtensionNode>();
    private final Map<String, DiscoveryExtensionNode> extensionIdMap;
    private final TransportService transportService;
    private final NodeClient client;

    public ExtensionTransportActionsHandler(Map<String, DiscoveryExtensionNode> extensionIdMap, TransportService transportService, NodeClient client) {
        this.extensionIdMap = extensionIdMap;
        this.transportService = transportService;
        this.client = client;
    }

    void registerAction(String action, DiscoveryExtensionNode extension) throws IllegalArgumentException {
        if (this.actionsMap.containsKey(action)) {
            throw new IllegalArgumentException("The " + action + " you are trying to register is already registered");
        }
        this.actionsMap.putIfAbsent(action, extension);
    }

    public DiscoveryExtensionNode getExtension(String action) {
        return this.actionsMap.get(action);
    }

    public TransportResponse handleRegisterTransportActionsRequest(RegisterTransportActionsRequest transportActionsRequest) {
        logger.debug("Register Transport Actions request recieved {}", (Object)transportActionsRequest);
        DiscoveryExtensionNode extension = this.extensionIdMap.get(transportActionsRequest.getUniqueId());
        try {
            for (String action : transportActionsRequest.getTransportActions().keySet()) {
                this.registerAction(action, extension);
            }
        }
        catch (Exception e) {
            logger.error("Could not register Transport Action " + e);
            return new AcknowledgedResponse(false);
        }
        return new AcknowledgedResponse(true);
    }

    public TransportResponse handleTransportActionRequestFromExtension(TransportActionRequestFromExtension request) throws Exception {
        DiscoveryExtensionNode extension = this.extensionIdMap.get(request.getUniqueId());
        final CompletableFuture inProgressFuture = new CompletableFuture();
        final TransportActionResponseToExtension response = new TransportActionResponseToExtension(new byte[0]);
        this.client.execute(ExtensionProxyAction.INSTANCE, new ExtensionActionRequest(request.getAction(), request.getRequestBytes()), new ActionListener<ExtensionActionResponse>(){

            @Override
            public void onResponse(ExtensionActionResponse actionResponse) {
                response.setResponseBytes(actionResponse.getResponseBytes());
                inProgressFuture.complete(actionResponse);
            }

            @Override
            public void onFailure(Exception exp) {
                logger.debug("Transport request failed", (Throwable)exp);
                byte[] responseBytes = ("Request failed: " + exp.getMessage()).getBytes(StandardCharsets.UTF_8);
                response.setResponseBytes(responseBytes);
                inProgressFuture.completeExceptionally(exp);
            }
        });
        try {
            inProgressFuture.orTimeout(10L, TimeUnit.SECONDS).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof TimeoutException) {
                logger.info("No response from extension to request.");
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        return response;
    }

    public ExtensionActionResponse sendTransportRequestToExtension(ExtensionActionRequest request) throws Exception {
        DiscoveryExtensionNode extension = this.actionsMap.get(request.getAction());
        if (extension == null) {
            throw new ActionNotFoundTransportException(request.getAction());
        }
        final CompletableFuture inProgressFuture = new CompletableFuture();
        final ExtensionActionResponse extensionActionResponse = new ExtensionActionResponse(new byte[0]);
        TransportResponseHandler<ExtensionActionResponse> extensionActionResponseTransportResponseHandler = new TransportResponseHandler<ExtensionActionResponse>(){

            @Override
            public ExtensionActionResponse read(StreamInput in) throws IOException {
                return new ExtensionActionResponse(in);
            }

            @Override
            public void handleResponse(ExtensionActionResponse response) {
                extensionActionResponse.setResponseBytes(response.getResponseBytes());
                inProgressFuture.complete(response);
            }

            @Override
            public void handleException(TransportException exp) {
                logger.debug("Transport request failed", (Throwable)exp);
                byte[] responseBytes = ("Request failed: " + exp.getMessage()).getBytes(StandardCharsets.UTF_8);
                extensionActionResponse.setResponseBytes(responseBytes);
                inProgressFuture.completeExceptionally(exp);
            }

            @Override
            public String executor() {
                return "generic";
            }
        };
        try {
            this.transportService.sendRequest(extension, "internal:extensions/handle-transportaction", new ExtensionHandleTransportRequest(request.getAction(), request.getRequestBytes()), extensionActionResponseTransportResponseHandler);
        }
        catch (Exception e) {
            logger.info("Failed to send transport action to extension " + extension.getName(), (Throwable)e);
        }
        try {
            inProgressFuture.orTimeout(10L, TimeUnit.SECONDS).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof TimeoutException) {
                logger.info("No response from extension to request.");
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        return extensionActionResponse;
    }
}

