/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.action;

import org.opensearch.action.ActionListener;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.extensions.ExtensionsManager;
import org.opensearch.extensions.action.ExtensionActionRequest;
import org.opensearch.extensions.action.ExtensionActionResponse;
import org.opensearch.node.Node;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class ExtensionTransportAction
extends HandledTransportAction<ExtensionActionRequest, ExtensionActionResponse> {
    private final String nodeName;
    private final ClusterService clusterService;
    private final ExtensionsManager extensionsManager;

    @Inject
    public ExtensionTransportAction(Settings settings, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ExtensionsManager extensionsManager) {
        super("cluster:internal/extensions", transportService, actionFilters, ExtensionActionRequest::new);
        this.nodeName = Node.NODE_NAME_SETTING.get(settings);
        this.clusterService = clusterService;
        this.extensionsManager = extensionsManager;
    }

    @Override
    protected void doExecute(Task task, ExtensionActionRequest request, ActionListener<ExtensionActionResponse> listener) {
        try {
            listener.onResponse(this.extensionsManager.handleTransportRequest(request));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

