/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.extensions.ExtensionsManager;
import org.opensearch.transport.TransportRequest;

public class ExtensionRequest
extends TransportRequest {
    private static final Logger logger = LogManager.getLogger(ExtensionRequest.class);
    private final ExtensionsManager.RequestType requestType;
    private final Optional<String> uniqueId;

    public ExtensionRequest(ExtensionsManager.RequestType requestType) {
        this(requestType, null);
    }

    public ExtensionRequest(ExtensionsManager.RequestType requestType, @Nullable String uniqueId) {
        this.requestType = requestType;
        this.uniqueId = uniqueId == null ? Optional.empty() : Optional.of(uniqueId);
    }

    public ExtensionRequest(StreamInput in) throws IOException {
        super(in);
        this.requestType = in.readEnum(ExtensionsManager.RequestType.class);
        String id = in.readOptionalString();
        this.uniqueId = id == null ? Optional.empty() : Optional.of(id);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum(this.requestType);
        out.writeOptionalString(this.uniqueId.orElse(null));
    }

    public ExtensionsManager.RequestType getRequestType() {
        return this.requestType;
    }

    public Optional<String> getUniqueId() {
        return this.uniqueId;
    }

    public String toString() {
        return "ExtensionRequest{requestType=" + this.requestType + "uniqueId=" + this.uniqueId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionRequest that = (ExtensionRequest)o;
        return Objects.equals((Object)this.requestType, (Object)that.requestType) && Objects.equals(this.uniqueId, that.uniqueId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestType, this.uniqueId});
    }
}

