/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.indices.SystemIndices;

public class SystemIndexMetadataUpgradeService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(SystemIndexMetadataUpgradeService.class);
    private final SystemIndices systemIndices;
    private final ClusterService clusterService;
    private boolean clusterManager = false;
    private volatile ImmutableOpenMap<String, IndexMetadata> lastIndexMetadataMap = ImmutableOpenMap.of();
    private volatile boolean updateTaskPending = false;

    public SystemIndexMetadataUpgradeService(SystemIndices systemIndices, ClusterService clusterService) {
        this.systemIndices = systemIndices;
        this.clusterService = clusterService;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        ImmutableOpenMap<String, IndexMetadata> indexMetadataMap;
        if (event.localNodeClusterManager() != this.clusterManager) {
            this.clusterManager = event.localNodeClusterManager();
        }
        if (this.clusterManager && !this.updateTaskPending && this.lastIndexMetadataMap != (indexMetadataMap = event.state().metadata().indices())) {
            for (ObjectObjectCursor<String, IndexMetadata> objectObjectCursor : indexMetadataMap) {
                if (objectObjectCursor.value == this.lastIndexMetadataMap.get((String)objectObjectCursor.key) || this.systemIndices.isSystemIndex(((IndexMetadata)objectObjectCursor.value).getIndex()) == ((IndexMetadata)objectObjectCursor.value).isSystem()) continue;
                this.updateTaskPending = true;
                this.clusterService.submitStateUpdateTask("system_index_metadata_upgrade_service {system metadata change}", new SystemIndexMetadataUpdateTask());
                break;
            }
        }
    }

    public class SystemIndexMetadataUpdateTask
    extends ClusterStateUpdateTask {
        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            ImmutableOpenMap<String, IndexMetadata> indexMetadataMap = currentState.metadata().indices();
            ArrayList<IndexMetadata> updatedMetadata = new ArrayList<IndexMetadata>();
            for (ObjectObjectCursor<String, IndexMetadata> objectObjectCursor : indexMetadataMap) {
                if (objectObjectCursor.value == SystemIndexMetadataUpgradeService.this.lastIndexMetadataMap.get((String)objectObjectCursor.key) || SystemIndexMetadataUpgradeService.this.systemIndices.isSystemIndex(((IndexMetadata)objectObjectCursor.value).getIndex()) == ((IndexMetadata)objectObjectCursor.value).isSystem()) continue;
                updatedMetadata.add(IndexMetadata.builder((IndexMetadata)objectObjectCursor.value).system(!((IndexMetadata)objectObjectCursor.value).isSystem()).build());
            }
            if (!updatedMetadata.isEmpty()) {
                Metadata.Builder builder = Metadata.builder(currentState.metadata());
                updatedMetadata.forEach(idxMeta -> builder.put((IndexMetadata)idxMeta, true));
                return ClusterState.builder(currentState).metadata(builder).build();
            }
            return currentState;
        }

        @Override
        public void onFailure(String source, Exception e) {
            SystemIndexMetadataUpgradeService.this.updateTaskPending = false;
            logger.error("failed to update system index metadata", (Throwable)e);
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            SystemIndexMetadataUpgradeService.this.lastIndexMetadataMap = newState.metadata().indices();
            SystemIndexMetadataUpgradeService.this.updateTaskPending = false;
        }
    }
}

