/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.indices.replication.SegmentReplicationStatsRequest;
import org.opensearch.action.admin.indices.replication.SegmentReplicationStatsResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.DefaultShardOperationFailedException;
import org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardId;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.replication.SegmentReplicationState;
import org.opensearch.indices.replication.SegmentReplicationTargetService;
import org.opensearch.rest.RestStatus;
import org.opensearch.transport.TransportService;

public class TransportSegmentReplicationStatsAction
extends TransportBroadcastByNodeAction<SegmentReplicationStatsRequest, SegmentReplicationStatsResponse, SegmentReplicationState> {
    private final SegmentReplicationTargetService targetService;
    private final IndicesService indicesService;
    private String singleIndexWithSegmentReplicationDisabled = null;

    @Inject
    public TransportSegmentReplicationStatsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, SegmentReplicationTargetService targetService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:monitor/segment_replication", clusterService, transportService, actionFilters, indexNameExpressionResolver, SegmentReplicationStatsRequest::new, "management");
        this.indicesService = indicesService;
        this.targetService = targetService;
    }

    @Override
    protected SegmentReplicationState readShardResult(StreamInput in) throws IOException {
        return new SegmentReplicationState(in);
    }

    @Override
    protected SegmentReplicationStatsResponse newResponse(SegmentReplicationStatsRequest request, int totalShards, int successfulShards, int failedShards, List<SegmentReplicationState> responses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        if (this.singleIndexWithSegmentReplicationDisabled != null) {
            String index = this.singleIndexWithSegmentReplicationDisabled;
            this.singleIndexWithSegmentReplicationDisabled = null;
            throw new OpenSearchStatusException("Segment Replication is not enabled on Index: " + index, RestStatus.BAD_REQUEST, new Object[0]);
        }
        String[] shards = request.shards();
        HashSet<String> set = new HashSet<String>();
        if (shards.length > 0) {
            for (String shard : shards) {
                set.add(shard);
            }
        }
        HashMap<String, List<SegmentReplicationState>> shardResponses = new HashMap<String, List<SegmentReplicationState>>();
        for (SegmentReplicationState segmentReplicationState : responses) {
            if (segmentReplicationState == null) continue;
            int shardId = segmentReplicationState.getShardRouting().shardId().id();
            if (shards.length > 0 && !set.contains(Integer.toString(shardId))) continue;
            String indexName = segmentReplicationState.getShardRouting().getIndexName();
            if (!shardResponses.containsKey(indexName)) {
                shardResponses.put(indexName, new ArrayList());
            }
            ((List)shardResponses.get(indexName)).add(segmentReplicationState);
        }
        return new SegmentReplicationStatsResponse(totalShards, successfulShards, failedShards, shardResponses, shardFailures);
    }

    @Override
    protected SegmentReplicationStatsRequest readRequestFrom(StreamInput in) throws IOException {
        return new SegmentReplicationStatsRequest(in);
    }

    @Override
    protected SegmentReplicationState shardOperation(SegmentReplicationStatsRequest request, ShardRouting shardRouting) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        ShardId shardId = shardRouting.shardId();
        if (request.indices().length == 1 && !indexShard.indexSettings().isSegRepEnabled()) {
            this.singleIndexWithSegmentReplicationDisabled = shardRouting.getIndexName();
            return null;
        }
        if (!indexShard.indexSettings().isSegRepEnabled()) {
            return null;
        }
        if (request.activeOnly()) {
            return this.targetService.getOngoingEventSegmentReplicationState(shardId);
        }
        if (request.completedOnly()) {
            return this.targetService.getlatestCompletedEventSegmentReplicationState(shardId);
        }
        return this.targetService.getSegmentReplicationState(shardId);
    }

    @Override
    protected ShardsIterator shards(ClusterState state, SegmentReplicationStatsRequest request, String[] concreteIndices) {
        return state.routingTable().allShardsIncludingRelocationTargets(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, SegmentReplicationStatsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, SegmentReplicationStatsRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }
}

