/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.remotestore.restore;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.ActionResponse;
import org.opensearch.common.Nullable;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ConstructingObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.rest.RestStatus;
import org.opensearch.snapshots.RestoreInfo;

public final class RestoreRemoteStoreResponse
extends ActionResponse
implements ToXContentObject {
    @Nullable
    private final RestoreInfo restoreInfo;
    public static final ConstructingObjectParser<RestoreRemoteStoreResponse, Void> PARSER = new ConstructingObjectParser("restore_remote_store", true, v -> {
        RestoreInfo restoreInfo = (RestoreInfo)v[0];
        Boolean accepted = (Boolean)v[1];
        assert (accepted == null && restoreInfo != null || accepted != null && accepted.booleanValue() && restoreInfo == null) : "accepted: [" + accepted + "], restoreInfo: [" + restoreInfo + "]";
        return new RestoreRemoteStoreResponse(restoreInfo);
    });

    public RestoreRemoteStoreResponse(@Nullable RestoreInfo restoreInfo) {
        this.restoreInfo = restoreInfo;
    }

    public RestoreRemoteStoreResponse(StreamInput in) throws IOException {
        super(in);
        this.restoreInfo = RestoreInfo.readOptionalRestoreInfo(in);
    }

    public RestoreInfo getRestoreInfo() {
        return this.restoreInfo;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.restoreInfo);
    }

    public RestStatus status() {
        if (this.restoreInfo == null) {
            return RestStatus.ACCEPTED;
        }
        return this.restoreInfo.status();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.restoreInfo != null) {
            builder.field("remote_store");
            this.restoreInfo.toXContent(builder, params);
        } else {
            builder.field("accepted", true);
        }
        builder.endObject();
        return builder;
    }

    public static RestoreRemoteStoreResponse fromXContent(XContentParser parser) throws IOException {
        return (RestoreRemoteStoreResponse)PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreRemoteStoreResponse that = (RestoreRemoteStoreResponse)o;
        return Objects.equals(this.restoreInfo, that.restoreInfo);
    }

    public int hashCode() {
        return Objects.hash(this.restoreInfo);
    }

    public String toString() {
        return "RestoreRemoteStoreResponse{restoreInfo=" + this.restoreInfo + "}";
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, context) -> RestoreInfo.fromXContent(parser), new ParseField("remote_store", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("accepted", new String[0]));
    }
}

