/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.authorization.MapPermissionTicketStore;
import org.keycloak.models.map.authorization.MapPolicyStore;
import org.keycloak.models.map.authorization.MapResourceServerStore;
import org.keycloak.models.map.authorization.MapResourceStore;
import org.keycloak.models.map.authorization.MapScopeStore;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntity;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;
import org.keycloak.models.map.authorization.entity.MapResourceServerEntity;
import org.keycloak.models.map.authorization.entity.MapScopeEntity;
import org.keycloak.models.map.storage.MapStorage;

public class MapAuthorizationStore
implements StoreFactory {
    private final MapPolicyStore policyStore;
    private final MapResourceServerStore resourceServerStore;
    private final MapResourceStore resourceStore;
    private final MapScopeStore scopeStore;
    private final MapPermissionTicketStore permissionTicketStore;
    private boolean readOnly;

    public MapAuthorizationStore(KeycloakSession session, MapStorage<MapPermissionTicketEntity, PermissionTicket> permissionTicketStore, MapStorage<MapPolicyEntity, Policy> policyStore, MapStorage<MapResourceServerEntity, ResourceServer> resourceServerStore, MapStorage<MapResourceEntity, Resource> resourceStore, MapStorage<MapScopeEntity, Scope> scopeStore, AuthorizationProvider provider) {
        this.permissionTicketStore = new MapPermissionTicketStore(session, permissionTicketStore, provider);
        this.policyStore = new MapPolicyStore(session, policyStore, provider);
        this.resourceServerStore = new MapResourceServerStore(session, resourceServerStore, provider);
        this.resourceStore = new MapResourceStore(session, resourceStore, provider);
        this.scopeStore = new MapScopeStore(session, scopeStore, provider);
    }

    public MapResourceStore getResourceStore() {
        return this.resourceStore;
    }

    public MapResourceServerStore getResourceServerStore() {
        return this.resourceServerStore;
    }

    public MapScopeStore getScopeStore() {
        return this.scopeStore;
    }

    public MapPolicyStore getPolicyStore() {
        return this.policyStore;
    }

    public MapPermissionTicketStore getPermissionTicketStore() {
        return this.permissionTicketStore;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void close() {
    }
}

