/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.model.Image;
import java.util.List;
import java.util.Map;
import org.testcontainers.shaded.com.github.dockerjava.core.command.AbstrDockerCmd;
import org.testcontainers.shaded.com.github.dockerjava.core.util.FiltersBuilder;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.shaded.org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.testcontainers.shaded.org.apache.commons.lang3.builder.ToStringStyle;

public class ListImagesCmdImpl
extends AbstrDockerCmd<ListImagesCmd, List<Image>>
implements ListImagesCmd {
    private String imageNameFilter;
    private Boolean showAll = false;
    private FiltersBuilder filters = new FiltersBuilder();

    public ListImagesCmdImpl(ListImagesCmd.Exec exec) {
        super(exec);
    }

    public Map<String, List<String>> getFilters() {
        return this.filters.build();
    }

    public Boolean hasShowAllEnabled() {
        return this.showAll;
    }

    public ListImagesCmd withShowAll(Boolean showAll) {
        this.showAll = showAll;
        return this;
    }

    public ListImagesCmd withDanglingFilter(Boolean dangling) {
        Preconditions.checkNotNull(dangling, "dangling have not been specified");
        this.filters.withFilter("dangling", dangling.toString());
        return this;
    }

    public ListImagesCmd withLabelFilter(String ... labels) {
        Preconditions.checkNotNull(labels, "labels have not been specified");
        this.filters.withLabels(labels);
        return this;
    }

    public ListImagesCmd withLabelFilter(Map<String, String> labels) {
        Preconditions.checkNotNull(labels, "labels have not been specified");
        this.filters.withLabels(labels);
        return this;
    }

    public ListImagesCmd withImageNameFilter(String imageNameFilter) {
        Preconditions.checkNotNull(imageNameFilter, "image name filter not specified");
        this.imageNameFilter = imageNameFilter;
        return this;
    }

    public String getImageNameFilter() {
        return this.imageNameFilter;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

