/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.utils.StringUtil;

public class GroupsResource {
    private final KeycloakSession session;
    private final RealmModel realm;
    private final AdminPermissionEvaluator auth;

    public GroupsResource(KeycloakSession session, RealmModel realm, AdminPermissionEvaluator auth) {
        this.realm = realm;
        this.auth = auth;
        this.session = session;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all groups with fine grained authorisation", description="This endpoint returns a list of groups with fine grained authorisation")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=GroupRepresentation.class, type=SchemaType.ARRAY))})
    public final Stream<GroupRepresentation> listGroups(@QueryParam(value="search") @DefaultValue(value="") String search, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="10") int max, @QueryParam(value="global") @DefaultValue(value="true") boolean global, @QueryParam(value="exact") @DefaultValue(value="false") boolean exact) {
        this.auth.groups().requireList();
        Stream stream = global ? this.session.groups().searchForGroupByNameStream(this.realm, search.trim(), Boolean.valueOf(exact), Integer.valueOf(first), Integer.valueOf(max)) : this.realm.getTopLevelGroupsStream().filter(g -> g.getName().contains(search)).skip(first).limit(max);
        return stream.map(g -> this.toGroupHierarchy((GroupModel)g, search, exact));
    }

    private GroupRepresentation toGroupHierarchy(GroupModel group, String search, boolean exact) {
        GroupRepresentation rep = ModelToRepresentation.toRepresentation((GroupModel)group, (boolean)true);
        rep.setAccess(this.auth.groups().getAccess(group));
        rep.setSubGroups(group.getSubGroupsStream().filter(g -> GroupsResource.groupMatchesSearchOrIsPathElement(g, search)).map(subGroup -> {
            GroupRepresentation subRep = ModelToRepresentation.toGroupHierarchy((GroupModel)subGroup, (boolean)true, (String)search, (Boolean)exact);
            subRep.setAccess(this.auth.groups().getAccess(subGroup));
            return subRep;
        }).collect(Collectors.toList()));
        return rep;
    }

    private static boolean groupMatchesSearchOrIsPathElement(GroupModel group, String search) {
        if (StringUtil.isBlank((String)search)) {
            return true;
        }
        if (group.getName().contains(search)) {
            return true;
        }
        return group.getSubGroupsStream().findAny().isPresent();
    }
}

